/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* $Id: fg-protocol-xml.h,v 1.1.1.1 2005/11/04 07:19:34 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifndef __FG_PROTOCOL_XML__
#define __FG_PROTOCOL_XML__

#include <glib.h>

#define FG_PROTO_ELM_ROOT     "smtpguard"
#define FG_PROTO_ELM_ADDR     "addr"
#define FG_PROTO_ELM_PID      "pid"
#define FG_PROTO_ELM_RCPTTO   "rcptto"
#define FG_PROTO_ELM_MAILFROM "mailfrom"
#define FG_PROTO_ELM_ACTION   "action"

#define FG_PROTO_ATTR_CODE    "code"
#define FG_PROTO_ATTR_WAIT    "wait"
#define FG_PROTO_ATTR_SESSION "session"
#define FG_PROTO_ATTR_MYDESTINATION "mydestination"
#define FG_PROTO_ATTR_MYNETWORKS    "mynetworks"

/* error report */
#define FG_PROTO_ELM_ERROR            "error"
#define FG_PROTO_ATTR_ERROR_CODE      "code"
#define FG_PROTO_ATTR_ERROR_DOMAIN    "domain"

/* XPath */
#define FG_PROTO_ROOT           "/"FG_PROTO_ELM_ROOT
#define FG_PROTO_SMTPGUARD      FG_PROTO_ROOT

#define FG_PROTO_ADDR           FG_PROTO_ROOT"/"FG_PROTO_ELM_ADDR"[1]"
#define FG_PROTO_PID            FG_PROTO_ROOT"/"FG_PROTO_ELM_PID"[1]"
#define FG_PROTO_RCPTTO         FG_PROTO_ROOT"/"FG_PROTO_ELM_RCPTTO"[1]"
#define FG_PROTO_MAILFROM       FG_PROTO_ROOT"/"FG_PROTO_ELM_MAILFROM"[1]"
#define FG_PROTO_ACTION         FG_PROTO_ROOT"/"FG_PROTO_ELM_ACTION"[1]"

#define FG_PROTO_ERROR          FG_PROTO_ROOT"/"FG_PROTO_ELM_ERROR"[1]"

FGSmtpInfo *fg_read_parse (GIOChannel *ioc, GError **error);
void fg_write_protocol (GIOChannel *ioc, const gchar *xmlbuff, gsize len,
			GError **error);
gchar *fg_protocol_error_get_xml (GError *report, GError **error);

#endif
