/*
 * ------------------------------------------------------------
 *  Debug Variable access
 * ------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <xy_hash.h>
#include <debugvars.h>

typedef struct DebugVarTable {
	XY_HashTable varHash;
} DebugVarTable;

static DebugVarTable debugVarTable;

typedef struct DebugVar {
	DebugVarOps *varOps;
	char *name;
	void *clientData;
	XY_HashEntry *hashEntry;	
} DebugVar;

DebugVar * 
DebugVar_New(DebugVarOps *ops,void *clientData,const char *namespace,const char *var) 
{
        char name[512];
	int len;
	int isnew;
        XY_HashEntry *entryPtr;
	DebugVar *dvar;
	len = strlen(namespace) + strlen(var) + 2;
	if(len > sizeof(name)) {
		return NULL;
	}
	sprintf(name,"%s.%s",namespace,var);
	entryPtr = XY_CreateHashEntry(&debugVarTable.varHash,name,&isnew);
	if(!isnew) {
		fprintf(stderr,"Var \"%s\" already exists\n",name);
		return NULL;
	}
	dvar = malloc(sizeof(DebugVar)); 
	if(!dvar) {
		fprintf(stderr,"Out of memory\n");
		exit(1);
	}
	XY_SetHashValue(entryPtr,dvar);
	dvar->varOps = ops;
	dvar->name = strdup(name);
	dvar->clientData = clientData;
	if(!dvar->name) {
		fprintf(stderr,"Out of memory\n");
		free(dvar);
		exit(1);
	}
	dvar->hashEntry = entryPtr;
	return dvar;
}

void
DebugVar_Delete(DebugVar *dvar) 
{
	XY_HashEntry *entryPtr;	
	entryPtr = dvar->hashEntry;
	XY_DeleteHashEntry(&debugVarTable.varHash,entryPtr);
	free(dvar->name);
	free(dvar);
}

static DebugVar * 
FindVarByName(const char *path) 
{
	XY_HashEntry *entryPtr;
	entryPtr = XY_FindHashEntry(&debugVarTable.varHash,path);
	if(!entryPtr) {
		return NULL;
	}
	return  XY_GetHashValue(entryPtr);
}

/*
 * ---------------------------------------------
 * DebugVar_Get
 * ---------------------------------------------
 */
char *
DebugVar_Get(const char *path) 
{
	DebugVarOps *vops;
	DebugVar *dvar;
	char *value;
	dvar = FindVarByName(path);
	if(!dvar)
		return NULL;
	vops = dvar->varOps;
	value  = vops->get(dvar->clientData);
	return value;
}

int
DebugVar_Set(const char *value, const char *path) 
{
	DebugVar *dvar;
	DebugVarOps *vops;
	int result;
	dvar = FindVarByName(path);
	if(!dvar)
		return -1;
	vops = dvar->varOps;
	result =  vops->set(dvar->clientData,value);
	return result;
}

/*
int
DebugVar_Trace(const char *path,TraceProc,int flags) 
{
	DebugVar *dvar;
	DebugVarOps *vops;
	int result;
	dvar = FindVarByName(path);
	if(!dvar)
		return -1;
	result = vops->trace(dvar->clientData,int flags);
	return result;
}
*/

void
DebugVars_Init(void) 
{
	 XY_InitHashTable(&debugVarTable.varHash,XY_STRING_KEYS,1024);
}
