/*
 * -------------------------------------------------------------------------
 * LPC2106 I2C 
 *      Emulation of the I2C Controller of the Phillips LPC2106
 *
 *
 * (C) 2005 Jochen Karrer
 *    Author: Jochen Karrer
 *
 * Status: not implemented
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * --------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdint>
#include <stdlib>
#include <string>
#include <unistd.h>
#include <bus.h>

#define REG_I2CONSET (0x00)
#define REG_I2CSTAT  (0x04)
#define REG_I2CDAT   (0x08)
#define REG_I2CADR   (0x0c)
#define	REG_SCLH     (0x10)
#define REG_SCLL     (0x14)
#define REG_ISCONCLR (0x18)

typedef struct LPC_I2C {
	BusDevice bdev;
} LPC_I2C;


static void
I2C_Map(void *owner,uint32_t base,uint32_t mask,uint32_t flags)
{
	LPC_I2C *i2c = (LPC_I2C*) owner;
}

static void
I2C_UnMap(void *owner,uint32_t base,uint32_t mask) 
{
	LPC_I2C *i2c = (LPC_I2C*) owner;

}

BusDevice *
LPC_I2CNew(const char *name) 
{
	LPC_I2C *i2c = (LPC_I2C *) malloc(sizeof(LPC_I2C));
	if(!i2c) {
		fprintf(stderr,"Out of memory\n");
		exit(7);	
	}		
	i2c->bdev.first_mapping=NULL;
       	i2c->bdev.Map=I2C_Map;
        i2c->bdev.UnMap=I2C_UnMap;
        i2c->bdev.owner=i2c;
        i2c->bdev.hw_flags=MEM_FLAG_WRITABLE|MEM_FLAG_READABLE;
	return &i2c->bdev;
}
