#include <stdint.h>
#include "diskimage.h" 
#include "signode.h"
	
#define CMDMODE_READ		(0)
#define CMDMODE_WRITE		(1)
#define CMDMODE_DATA_IN		(2)
#define CMDMODE_DATA_OUT	(3)
#define CMDMODE_READ_BUSY	(4)
#define CMDMODE_PGM_BUSY	(5)
#define CMDMODE_ERASE_BUSY	(6)
#define CMDMODE_WRITE_PROTECT	(7)
#define CMDMODE_WRITE_STDBY	(8)
	
typedef struct NandFlashCmd {
	int cmdmode;
	uint8_t cmd[4];
	int cmdlen;
	uint8_t address[4];
} NandFlashCmd;

typedef struct NandFlashDevice {
	char *type;
	DiskImage *disk_image;
	SigNode *busySig;
	int page_pointer; /* A Area 0-255, B Area 256-511, C-Area 512-527 */
	int state;
} NandFlashDevice;
