/*
 * ----------------------------------------------------
 *
 * PowerPC Memory Management Unit 
 * (C) 2004  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 * ----------------------------------------------------
 */

#include <bus.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <cpu_ppc.h>


static uint32_t 
translate_data(uint32_t va) 
{
	if(!gcpu.msr_dr) {
		return va;
	} else {
		fprintf(stderr,"Mist\n");
		exit(4234);
	}
}
static uint32_t 
translate_ifetch(uint32_t va) 
{
	if(!gcpu.msr_ir) {
		return va;
	} else {
		fprintf(stderr,"Mist\n");
		exit(4237);
	}
}
/*
 * -------------------------------------------
 * Non-Static version of Page table walk
 * -------------------------------------------
 */
uint32_t
MMU_translate_ifetch(uint32_t va) {
        return translate_ifetch(va);
}


uint64_t 
MMU_Read64(uint32_t va) {
	uint32_t pa=translate_data(va);	
	return Bus_Read64(pa);

}
uint32_t 
MMU_Read32(uint32_t va) {
	uint32_t pa=translate_data(va);	
	return Bus_Read32(pa);

}

uint16_t 
MMU_Read16(uint32_t va) {
	uint32_t pa=translate_data(va);	
	return Bus_Read16(pa);
}

uint8_t  
MMU_Read8(uint32_t va) {
	uint32_t pa=translate_data(va);	
	return Bus_Read16(pa);
}

void 
MMU_Write64(uint32_t value,uint32_t va) {
	uint32_t pa=translate_data(va);	
	Bus_Write64(value,pa);
}
void 
MMU_Write32(uint32_t value,uint32_t va) {
	uint32_t pa=translate_data(va);	
	Bus_Write32(value,pa);
}
void 
MMU_Write16(uint16_t value,uint32_t va) {
	uint32_t pa=translate_data(va);	
	Bus_Write16(value,pa);
}
void 
MMU_Write8(uint8_t value,uint32_t va) {
	uint32_t pa=translate_data(va);	
	Bus_Write8(value,pa);
}

void MMU_InvalidateTlb() {

}
