/* Somaplayer - Copyright (C)>003 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif
#ifdef ENABLE_SNDFILE
#include "../../player.h"
#include "../../audio.h"
#include "../../util.h"
#include "../../other.h"
#include "../../output.h"
#include "fsndfile.h"

void
sndfile_quit (audio * output)
{
  audio_data_sndfile *sndfile = (audio_data_sndfile *) output->data;

  if (sndfile && sndfile->fd)
    sf_close ((SNDFILE *) sndfile->fd);
  else
    return;
}

void
sndfile_show (audio * output)
{
  audio_data_sndfile *sndfile = (audio_data_sndfile *) output->data;

  if (!sndfile)
    return;

  switch (output->audio_type)
    {

    case USE_WAV:
      msg (_
	   ("Audio Device:\n\tType: Microsoft WAV format (little endian)\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_AIFF:
      msg (_
	   ("Audio Device:\n\tType: Apple/SGI AIFF format (big endian)\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_AU:
      msg (_
	   ("Audio Device:\n\tType: Sun/NeXT AU file format (big endian)\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_RAW:
      msg (_
	   ("Audio Device:\n\tType: Raw PCM data\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_PAF:
      msg (_
	   ("Audio Device:\n\tType: Ensoniq PARIS file format\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_SVX:
      msg (_
	   ("Audio Device:\n\tType: Amiga IFF / SVX8 / SV16 format\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_NIST:
      msg (_
	   ("Audio Device:\n\tType: Sphere NIST format\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_VOC:
      msg (_
	   ("Audio Device:\n\tType: Voc files\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_IRCAM:
      msg (_
	   ("Audio Device:\n\tType: Berkeley/IRCAM/CARL\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_W64:
      msg (_
	   ("Audio Device:\n\tType: Sonic Foundry's 64 bit RIFF/WAV\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_MAT4:
      msg (_
	   ("Audio Device:\n\tType: Matlab (tm) V4.2 / GNU Octave 2.0\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_MAT5:
      msg (_
	   ("Audio Device:\n\tType: Matlab (tm) V5.0 / GNU Octave 2.1\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_PVF:
      msg (_
	   ("Audio Device:\n\tType: Portable Voice Format\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_XI:
      msg (_
	   ("Audio Device:\n\tType: Fasttracker 2 Extended Instrument\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

    case USE_HTK:
      msg (_
	   ("Audio Device:\n\tType: HMM Tool Kit format\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;

#ifdef USE_MIDI
    case USE_MIDI:
      msg (_
	   ("Audio Device:\n\tType: Midi Sample Dump Standard\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;
#endif

#ifdef USE_AVR
    case USE_AVR:
      msg (_
	   ("Audio Device:\n\tType: Audio Visual Research\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;
#endif

#ifdef USE_WAVEX
    case USE_WAVEX:
      msg (_
	   ("Audio Device:\n\tType: MS WAVE with WAVEFORMATEX\n\tSamplerate %d\n\tChannels %d\n"),
	   sndfile->info.samplerate, sndfile->info.channels);
      break;
#endif
    }
}

int
sndfile_init (audio * output, long rate, int channels, int bitrate)
{

  audio_data_sndfile *data = (audio_data_sndfile *) output->data;
  char *fl;

  if (!data)
    fatal (_("Internal error."));

  data->info.channels = channels;
  data->info.samplerate = rate;
  data->info.seekable = 1;
  data->info.sections = 1;

  switch (output->audio_type)
    {
    case USE_WAV:
      data->info.format = SF_FORMAT_WAV | SF_FORMAT_PCM_16;
      break;

    case USE_AIFF:
      data->info.format = SF_FORMAT_AIFF | SF_FORMAT_PCM_16;
      break;

    case USE_AU:
      data->info.format = SF_FORMAT_AU | SF_FORMAT_PCM_16;
      break;

    case USE_RAW:
      data->info.format = SF_FORMAT_RAW | SF_FORMAT_PCM_16;
      break;

    case USE_PAF:
      data->info.format = SF_FORMAT_PAF | SF_FORMAT_PCM_16;
      break;

    case USE_SVX:
      data->info.format = SF_FORMAT_SVX | SF_FORMAT_PCM_16;
      break;

    case USE_NIST:
      data->info.format = SF_FORMAT_NIST | SF_FORMAT_PCM_16;
      break;

    case USE_VOC:
      data->info.format = SF_FORMAT_VOC | SF_FORMAT_PCM_16;
      break;

    case USE_IRCAM:
      data->info.format = SF_FORMAT_IRCAM | SF_FORMAT_PCM_16;
      break;

    case USE_W64:
      data->info.format = SF_FORMAT_W64 | SF_FORMAT_PCM_16;
      break;

    case USE_MAT4:
      data->info.format = SF_FORMAT_MAT4 | SF_FORMAT_PCM_16;
      break;

    case USE_MAT5:
      data->info.format = SF_FORMAT_MAT5 | SF_FORMAT_PCM_16;
      break;

    case USE_PVF:
      data->info.format = SF_FORMAT_PVF | SF_FORMAT_PCM_16;
      break;

    case USE_XI:
      data->info.format = SF_FORMAT_XI | SF_FORMAT_PCM_16;
      break;

    case USE_HTK:
      data->info.format = SF_FORMAT_HTK | SF_FORMAT_PCM_16;
      break;

#ifdef USE_MIDI
    case USE_MIDI:
      data->info.format = SF_FORMAT_SDS | SF_FORMAT_PCM_16;
      break;
#endif

#ifdef USE_AVR
    case USE_AVR:
      data->info.format = SF_FORMAT_AVR | SF_FORMAT_PCM_16;
      break;
#endif

#ifdef USE_WAVEX
    case USE_WAVEX:
      data->info.format = SF_FORMAT_WAVEX | SF_FORMAT_PCM_16;
      break;
#endif

    default:
      fatal (_("Internal error."));

    }

  fl = output_check_file (output->audio_dev);

  if (!(data->fd = sf_open (fl, SFM_WRITE, &data->info)))
    {
      msg_error (_("Error opening snd file: %s - %s"), fl,
		 sf_strerror (NULL));
      return 1;
    }

  free (fl);

  return 0;
}

int
sndfile_check (audio * output)
{
  return 1;
}

int
sndfile_write (audio * output, int channels, int bitrate, void *data, size_t length)
{
  audio_data_sndfile *a = (audio_data_sndfile *) output->data;

  if (!a)
    return 1;

  sf_write_raw (a->fd, data, length);

  return 0;
}
#endif
