/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "time.h"
#include "other.h"

/* Init a timer element */
struct timeval *
timer_start (void)
{
  struct timeval *start = malloc (sizeof (struct timeval));

  if (!start)
    fatal ("Error: memory.");

  gettimeofday (start, NULL);
  return start;
}

/* Get the difference */
double
timer_time (struct timeval *timer)
{
  struct timeval now;
  struct timeval start = *timer;

  gettimeofday (&now, NULL);

  return ((double) now.tv_sec - (double) start.tv_sec) +
    ((double) now.tv_usec - (double) start.tv_usec) / 1000000.0;
}

/* Get the difference in usec */
double
timer_time_u (struct timeval *timer)
{
  struct timeval now;
  struct timeval start = *timer;

  gettimeofday (&now, NULL);

  return (((double) now.tv_sec - (double) start.tv_sec) * 1000000.0) +
    ((double) now.tv_usec - (double) start.tv_usec);
}

/* Clear all */
void
timer_clear (struct timeval *timer)
{
  if (timer)
    free (timer);
}

/* EOF */
