

#ifndef OPTIONS_H
#define OPTIONS_H

#include <qwidget.h>

#include "conversionoptions.h"

#include <kio/jobclasses.h>

class OptionsSimple;
class OptionsDetailed;
class Config;

class QStringList;
class KTabWidget;
class KPushButton;


/**
 * All we need to know about a profile
 */
struct ProfileData
{
    QString name;
    ConversionOptions options;
};


/**
 * The data pool
 */
// struct OptionsData
// {
//     QString name;
//     ConversionOptions options;
// };


/**
 * @short The widget, where we can set our output options
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class Options : public QWidget
{
    Q_OBJECT
public:
    /**
     * Constructor
     */
    Options( Config*, const QString &text, QWidget* parent = 0, const char* name = 0 );

    /**
     * Destructor
     */
    virtual ~Options();

    /**
     * Return the current options
     */
    ConversionOptions getCurrentOptions();

public slots:
    /**
     * Set the current options
     */
    void setCurrentOptions( const ConversionOptions& );

    /**
     * Set the current profile
     */
    void setProfile( const QString& );

    /**
     * Set the current format
     */
    void setFormat( const QString& );

    /**
     * Set the current output directory
     */
    void setOutputDirectory( const QString& );

private:
    /** Toggle between normal and advanced options in the detailed tab */
    KPushButton* pAdvancedOptionsToggle;

    //** Notify the user about new plugins */
//     KPushButton* pPluginsNotify;
    /** Notify the user about new / lost backends */
    KPushButton* pBackendsNotify;

    KTabWidget* tab;

    OutputDirectory* outputDirectory;

    OptionsSimple* optionsSimple;
    OptionsDetailed* optionsDetailed;

    Config *config;

    KIO::FileCopyJob* getPluginListJob;

    // /** Copy all options from the detailed tab to the simple tab / find the matching profile */
    //void updateSimpleTab();

private slots:
    void tabChanged( QWidget* );
    void somethingChanged();
    void configChanged();
//     void getPluginListFinished( KIO::Job* job );
//     void showConfigDialogPlugins();
    void showConfigDialogBackends();

signals:
    void optionsChanged();
    void showConfigPluginsPage();
    void showConfigEnvironmentPage();
};

#endif // OPTIONS_H
