

#ifndef REPLAYGAINFILELIST_H
#define REPLAYGAINFILELIST_H

#include <klistview.h>

#include <qdatetime.h>


class TagEngine;
class TagData;
class ReplayGain;
class Config;
class Logger;

class QSimpleRichText;
class KProgress;

class KPopupMenu;
class KAction;
class KActionCollection;
class KProcess;

// FIXME differ diffrent sampling rates, too!

/**
 * @short The items for the file list of the Replay Gain scanner
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ReplayGainFileListItem : public KListViewItem
{
public:
    enum Type {
        File,
        Album
    };

    enum Mode {
        remove            = 0x0001,
        force             = 0x0002
    };

    /**
     * Constructor
     * @param parent The parent list view
     */
    ReplayGainFileListItem( QListView* parent );

    /*
     * Constructor
     * @param parent The parent list view
     * @param after The item, the new item should be placed after
     */
    //ReplayGainFileListItem( QListView* parent, QListViewItem* after );

    /**
     * Constructor
     * @param parent The parent list view item
     */
    ReplayGainFileListItem( ReplayGainFileListItem* parent );

    /**
     * Destructor
     */
    virtual ~ReplayGainFileListItem();

    virtual void paintCell( QPainter* p, const QColorGroup& cg, int column, int width, int alignment );

    int compare( QListViewItem* item, int column, bool ascending ) const;

    void updateReplayGainCells( TagData* );

    ReplayGainFileListItem* firstChild() const { return static_cast<ReplayGainFileListItem*>( KListViewItem::firstChild() ); }
    ReplayGainFileListItem* nextSibling() const { return static_cast<ReplayGainFileListItem*>( KListViewItem::nextSibling() ); }
    //ReplayGainFileListItem* itemBelow() { return static_cast<ReplayGainFileListItem*>( KListViewItem::itemBelow() ); }
    ReplayGainFileListItem* parent() const { return static_cast<ReplayGainFileListItem*>( KListViewItem::parent() ); }

    Type type() { return m_type; }
    void setType( Type );

    // FIXME file list

    /* TODO check sampling rate, too
     * metaflac: 8, 11.025, 12, 16, 22.05, 24, 32, 44.1, or 48 kHz.
     */

    QString filePathName;       // the path and name of the file
    //QString fileName;           // just the _name_ of the file
    QString mimeType;           // the mime type of the file / the mime type of all files in this album
    QString fileFormat;         // just the _format_ of the file / the format of all files in this album (for easier use)
    QString originalFileFormat; // after renaming we need to re-rename the file
    bool addingReplayGain;      // are we adding replay gain tags at the moment?
    bool queued;                // is this item queued for adding/removing replay gain?
    Mode mode;
    float time;                 // the duration of the track, used for the calculation of the progress bar

private:
    Type m_type;
};


/**
 * @short The file list of the Replay Gain scanner
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ReplayGainFileList : public KListView
{
    Q_OBJECT
public:
    /**
     * Constructor
     * @param parent The parent widget
     * @param name The name of the file list
     */
    ReplayGainFileList( TagEngine*, Config*, Logger*, QWidget *parent=0, const char *name=0 );

    /**
     * Destructor
     */
    virtual ~ReplayGainFileList();

    ReplayGainFileListItem* firstChild() const { return static_cast<ReplayGainFileListItem*>( KListView::firstChild() ); }
    ReplayGainFileListItem* itemAt( const QPoint& point ) const { return static_cast<ReplayGainFileListItem*>( KListView::itemAt(point) ); }

    int columnByName( const QString& name );

protected:
    virtual bool acceptDrag( QDropEvent *e ) const;

private slots:
    void columnResizeEvent( int, int, int );
    void openAlbums();
    void closeAlbums();
    void update();

public slots:
    void addFile( const QString& );
    void addDir( const QString&, const QStringList& filter = "" );
    void calcAllReplayGain( bool force );
    void removeAllReplayGain();
    void cancelProcess();

private:
    /** Lists all file in a directory and adds them to the file list, if @p fast is false. The number of listed files is returned */
    int listDir( const QString& directory, QStringList filter, bool fast = false, int count = 0 );

    /** A progressbar, that is shown, when a directory is added recursive */
    KProgress* pScanStatus;

    TagEngine* tagEngine;
    Config* config;
    Logger* logger;

    KProcess* process;
    ReplayGain* replayGain;
    int logID;

    void contentsDragEnterEvent( QDragEnterEvent *e );
    void contentsDragMoveEvent( QDragMoveEvent *e );
    void contentsDropEvent( QDropEvent *e );

    void viewportPaintEvent( QPaintEvent* );
    void viewportResizeEvent( QResizeEvent* );

    QSimpleRichText* bubble;

    void startProcess();

    void processNextFile();

    void calcReplayGain( ReplayGainFileListItem* );
    void removeReplayGain( ReplayGainFileListItem* );

    bool queue;
    ReplayGainFileListItem::Mode mode;
    ReplayGainFileListItem* currentItem;

    QTimer* tUpdateProgress;
    bool processing;        // true, if the progress is active (hide some options in the context menu)
    int percent;            // the progress of the current file / album
    int lastPercent;        // cache the last percent in order to record a 'track change'
    float time;             // track length of all files
    float processedTime;    // the sum of all track lengths of the processed files
    int files;              // the number of files in the current album
    int file;               // the file that is being 'replay gained'
    float timeCount;        // the sum of all track lengths in the current album / the track length of the current file

    /** The context menu for editing or starting the files */
    KPopupMenu* contextMenu;

    KActionCollection* actionCollection;
    KAction* calc_gain;
    KAction* remove_gain;
    KAction* newalbum;
    KAction* remove;
    KAction* paste;
    KAction* open_albums;
    KAction* close_albums;

private slots:
    void showContextMenu( QListViewItem*, const QPoint&, int );

    /**
     * Remove selected items from the file list
     */
    void removeSelectedItems();

    /**
     * Creates a new 'album' item in the list view
     */
    void createNewAlbum();

    /**
     * Calculates the replay gain tags of the selected items
     */
    void calcSelectedItemsGain();

    /**
     * Remove the replay gain tags of the selected items
     */
    void removeSelectedItemsGain();

    void slotDropped( QDropEvent*, QListViewItem*, QListViewItem* ); // NOTE rename?

    void processOutput( KProcess*, char*, int );
    void processExit( KProcess* );

signals:
    //void calcGain();
    //void removeGain();
//     void addFile( const QString& filename );

    void processStarted();
    void processStopped();
    void updateProgress( int, int );

};

#endif // REPLAYGAINFILELIST_H
