#include "header.h"

/*
 * Protocol:
 * Request: ID type
 * Reply: ID data
 * Type: 1 (average volume)
 *   Data: R/P/- channels volume0(0-100) volume1 ...
 *
 *
 */

int monsock;
int monport=NET_PORT-1;
short playmax[MAX_CHANNELS];
struct timeval playmaxstamp[MAX_CHANNELS];
int channels;

struct sockaddr_in monrep_sin;
socklen_t monrep_socklen;

int init_mon(void){
    int on;
    struct sockaddr_in sin;
    socklen_t socklen;
    
    channels=1;

    memset(playmax, 0, sizeof(playmax));
//    memset(playmaxstamp, 0, sizeof(playmaxstamp));

    monsock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (monsock < 0) goto err;

    on=1;
/*    if (setsockopt(monsock, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on))){
        error("Can't set SO_REUSEADDR");
        goto err;
    }*/
    
    if (fcntl(monsock, F_SETFL, O_NONBLOCK)){
        error("Can't set O_NONBLOCK");
        goto err;
    }
    
    memset(&sin, 0, sizeof(struct sockaddr_in));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(monport);
    sin.sin_addr.s_addr = INADDR_ANY;
    if (bind(monsock, (struct sockaddr *)&sin, sizeof(sin))){
        error("Can't bind UDP port %d", monport);
        goto err;
    }
    
    memset(&sin, 0, sizeof(sin));
    socklen = sizeof(sin);
    getsockname(monsock, (struct sockaddr *) &sin, &socklen);
    
    set_handlers(monsock, mon_read_handler, NULL, NULL, NULL);
    

    return 0;
err:;
    close(monsock);
    monsock = -1;
    
    /* kill_timer not needed */
    return 1;    
}


void free_mon(){
    set_handlers(monsock, NULL, NULL, NULL, NULL);
    if (monsock>=0) close(monsock);
    monsock=-1;
}

#define DELIM " \r\n"
void mon_read_handler(void *data){
    char s[1024],*token_ptr;
    struct sockaddr_in sin;
    socklen_t socklen;
    int rcvd;
    char *id,*cmd;
    GString *gs;
    int i;
    struct timeval now;
    
    //dbg("mon_read_handler()\n");

    memset(s, 0, sizeof(s));
    socklen = sizeof(sin);
    rcvd=recvfrom(monsock, s, sizeof(s)-1, 0, 
            (struct sockaddr *)&sin, &socklen);

    if (rcvd<0) return;
    
    if (strlen(s)>0 && s[strlen(s)-1]=='\n') s[strlen(s)-1]='\0';
    if (strlen(s)>0 && s[strlen(s)-1]=='\r') s[strlen(s)-1]='\0';
    if (*s=='\0') return;

//    dbg("s='%s'\n", s);
    id= strtok_r(s, DELIM, &token_ptr);
//    dbg("id=%p\n", id);
    if (!id) return;
    cmd=strtok_r(NULL, DELIM, &token_ptr);
//    dbg("cmd=%p\n", cmd);
    if (!cmd) return;
    
    gs=g_string_sized_new(20+channels*4);
    g_string_sprintf(gs, "%s %d ", id, channels);
    gettimeofday(&now, NULL);
  //  dbg("channels=%d\n",channels);
    for (i=0;i<channels;i++){
        long int delta/*,val*/;
        double logar;
        
        delta=(now.tv_usec-playmaxstamp[i].tv_usec)/1000;
        //  if (delta<0) delta+=1000;
        delta+=(now.tv_sec-playmaxstamp[i].tv_sec)*1000;
        if (delta>300) playmax[i]=0;
#if 0        
        delta=now.tv_sec-playmaxstamp[i].tv_sec;
        if (delta>10) {    /* more than 10 sec */
            playmax[i]=0;
        }else{
            delta=(now.tv_usec-playmaxstamp[i].tv_usec)/1000;
          //  if (delta<0) delta+=1000;
            delta+=(now.tv_sec-playmaxstamp[i].tv_sec)*1000;
            if (delta<=0) delta=1;
            
   /*         val=playmax[i];
            val-=delta*20;
            if (val<-0) val=0;
   //         dbg("delta=%d val=%d->%d\n", delta, playmax[i],val);
            playmax[i]=val;*/
            playmaxstamp[i].tv_sec=now.tv_sec;
            playmaxstamp[i].tv_usec=now.tv_usec;
        }
#endif        
        if (playmax[i]){
            logar=(9.6178*log((double)playmax[i]));
        }else{
            logar=0;
        }
        g_string_sprintfa(gs, "%d", (int)logar);
/*        if (i==0){
            dbg("playmax[%d]=%6d logar=%6d\n",i, playmax[i], (int)logar);
        }*/
    }
    g_string_append_c(gs, '\n');
    sendto(monsock, gs->str, strlen(gs->str), 0, (struct sockaddr *)&sin, socklen);
    g_string_free(gs, 1);


    return;
}
