/* @(#)termcap.h	1.6 03/06/15 Copyright 1995 J. Schilling */
/*
 *	Copyright (c) 1995 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#ifndef	_TERMCAP_H
#define	_TERMCAP_H

#ifndef _MCONFIG_H
#include <mconfig.h>
#endif
#ifndef _PROTOTYP_H
#include <prototyp.h>
#endif

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Flags for tcsetflags()
 */
#define	TCF_NO_TC		0x0001	/* Don't follow tc= entries */
#define	TCF_NO_SIZE		0x0002	/* Don't get actual ttysize (li#/co#)*/
#define	TCF_NO_STRIP		0x0004	/* Don't strip down termcap buffer */

extern	char	PC;		/* Pad character */
extern	char	*BC;		/* Backspace if not "\b" from "bc" capability*/
extern	char	*UP;		/* Cursor up string from "up" capability */
extern	short	ospeed;		/* output speed coded as in ioctl */

extern	int	tgetent		__PR((char *bp, char *name));
extern	int	tcsetflags	__PR((int flags));
extern	char	*tcgetbuf	__PR((void));
extern	int	tgetnum		__PR((char *ent));
extern	BOOL	tgetflag	__PR((char *ent));
extern	char	*tgetstr		__PR((char *ent, char **array));
extern	char	*tdecode		__PR((char *ep, char **array));

extern	int	tputs		__PR((char *cp, int affcnt, int (*outc)(int c)));
extern	char	*tgoto		__PR((char *cm, int destcol, int destline));

#ifdef	__cplusplus
}
#endif

#endif	/* _TERMCAP_H */
