// import Visconte.Onto;
// import Visconte;


class OWLItem
//{{{ 
{
/**
 * <p>class OWLItem - Represents an abstract OWL Item. this class shouldnt be instantiated not directly. Use one of the Subclasses instead
 * with dynamic binding OWLItem x = OWLClass(....), you can bind the this class in your code
 *
 * Construction of all subclasses OWLItems:
 * 		For a construction of a new Item use the OWLItemFactory Class - it checks the data for consitence
 *		For retrieval use the get_item methods in class ontology, which will return valid and existing items
 *
 * Changes to Items:
 *		If you change any property in an item it will not directly be saved to the ontology. If you want to commit your changes
 *		use the method update(OWLItem) in class ontology e.g. from the ActionClass with ontology->update(YourItem)
 *
 * Not functional by now:
 *		The euqivalent and different_from restrictions on a class are implementend it this datatstructure, but not in the ontology class.
 *		The restrictions of properties e.g. symetric etc. are also functional here, but not in the ontology class
 * 		Working with this elements will (up to now) not be represented in the ontology
 * </p>
 */


    
    
/**
 * <p>Represents the type of the item, with the constants listed below,
 * subclasses have to replace this type</p>
 */
    public constant ITEMTYPE = 0;

/**
 * <p>Represents a Class</p>
 */
    public constant CLASS = 1;

/**
 * <p>Represents an Individual</p>
 */
    public constant  INDIVIDUAL = 2;

/**
 * <p>Represents an Oject Property</p>
 */
    public constant  OBJECT_PROPERTY = 3;

/**
 * <p>Represents Datatype Property</p>
 */
    public constant  DATATYPE_PROPERTY = 4;

/**
 * <p>Represents the unique id of the item
 * to ensure this id is really unique, items should 
 * be constructed with OWLItemFactory</p>
 */
    static string id;

/**
 * <p>Represents the ontology, this 
 * variable will be init in the subclasses</p>
 */
    static Visconte.Onto.Ontology ontology;
    
/**
 * <p>Represents the labels with the 
 * connected language flag, e.g en fr de etc.
 * ["en"]:["my label"]</p>
 */
    static mapping(string:string) label =(["en":""]);
    
 
/**
 * <p>Returns the date of last change in unixtime</p>
 * 
 * 
 * @return string timestamp
 */
    public string get_date_of_change() {        
       return ontology->get_meta(this_object())["lastChanged"];
    } 

/**
 * <p>Returns the author last edited the item</p>
 * 
 * 
 * @return string name of author
 */
    public string get_last_author() {        
       return ontology->get_meta(this_object())["author"];
    } 
    
    
/**
 * <p>Returns the id of the Item</p>
 * 
 * 
 * @return string id
 */
    public string get_Id() {        
        
        return id;
    } 

    
    
/**
 * <p>Test for inequality</p>
 * 
 * 
 * @return int 0|1
 */
    public int `!=(OWLItem item) {        
        
       return !is_equal(item);
    } 

    
    
/**
 * <p>Test for equality by id comapring the id's</p>
 * 
 * 
 * @return 
 */
    public int is_equal(OWLItem item) {        
        
       return(this_program::id==item->get_Id());
    } 


/**
 * <p>Sets a label for the desired language</p>
 * the mapping is structured as language code (ed,de,etc...) and label
 * currently only english is supported!
 * 
 * @param mapping label the label
 */
    public void set_Label(mapping label) 
    { 
	//set the label to the language
	if(label)
		this_program::label=label;
	
	
    } 

/**
 * <p>Get the label for the desired language</p>
 * currently en is the only supported language code
 * 
 * @param string lang - the language code (en,de etc..) 
 * @return 
 */
    public string get_Label(string|void lang) 
    {  
	    string item_label="";
	    if(lang)
	    {
		    item_label = label[lang];
	    }
	    else
	    {    
		    item_label = label["en"]; 
	    }
	    
		 
		 
	    return item_label;
    } 

} //}}}

/**   
*
* <p>Class OWLClass
* Represents an OWL Class Element and provides different properties and connections to other items</p>
* see Comment Header in OWLItem for more details!
*
*
*/
class OWLClass
//{{{ 
{
inherit OWLItem;




/**
 * <p>Represents the type of the item, which is CLASS here</p>
 */
    public constant ITEMTYPE = CLASS;	
	
/**
 * <p>Represents the id of the parent class</p>
 */
    public mixed parent_id;

/**
 * <p>Represents the ids of the direct childs</p>
 */
    private array childs ;
/**
 * <p>Represents  the connected individuals</p>
 */
    private array individuals ;
    
/**
 * <p>Represents the connected properties whrer this class is the domain object</p>
 */
    private  array domain_properties ;
    
/**
 * <p>Represents the connected properties where this class is the range object</p>
 */
    private  array range_properties ;
    
/**
 * <p>contains all class which are set equal to this one</p>
 */
    private array equivalent_Class=({});
    
    
/**
 * <p>Contains all class which are set different from this</p>
 */
    private array different_From=({});;

    
/**
* <p>Construct a Class</p>
* 
* 
* @param ontology - the ontology object operating on
* @param id - the id of the class 
* @param mixed parent_id - class id this is subclass of
*        (either int 0, which will be a subclass of Thing, or the id as string)
* @param mapping label - the label mapping (e.g. (["en":"Iam the label"])
* @param array domain_properties - array with the ids of the Object- and DataProperties this class acts as domain in
* @param array range_properties - array with the ids of the ObjectProperties this class acts as range in
* @param array childs - array with the ids of the subclasses
* @param array individuals - array with the ids of the individuals which where templated from this class (not inherited!)
* @param array equivalent_Class - array with the ids of the equivalent classes
* @param array different_From - array with the ids of the different classes which are different from

*/
    public void create(Visconte.Onto.Ontology ontology, string id, mixed parent_id, mapping label,
    array domain_properties, array range_properties, array childs, array individuals, array equivalent_Class, array different_From) 
    {        
	
        this_program::id=id;
	
	if(parent_id==0)
		this_program::parent_id="#Thing";
	else
		this_program::parent_id=parent_id;
	this_program::ontology=ontology;
	if(label)
		this_program::label=label;
	this_program::domain_properties = domain_properties;
	this_program::childs = childs;
	this_program::individuals=individuals;
	this_program::range_properties=range_properties;
	this_program::equivalent_Class=equivalent_Class;
	this_program::different_From=different_From;
    } 


/**
 * <p>Is this class a document term</p>
 * 
 * 
 * @return boolean
 */
    public int is_document_term()
    {
	    int isDocumentTerm = 0;
	    if(ontology->is_document_term(this_object()))
		    isDocumentTerm=1;
	    else
	    {
		    object owl_class = this_object();
		    while(owl_class->has_parent())
		    {
			    owl_class=owl_class->get_parent();
			    if(ontology->is_document_term(owl_class))
			    {	
				    
				    isDocumentTerm=1;
				    break;
			    }
				  
		    }	  
	    }
	    return isDocumentTerm;   
    }
/**
 * <p>This Method adds the equivalenClass and differentFrom to the 
 *    associated classes </p>
 * 
 * 
 * @return 
 */
    public void mirror_restrictions()
    {
	    //if myself exists in the ontology
	    if(ontology->item_exists(this_program::id))
	    {
			foreach (equivalent_Class, string class_id)
			{
				equivalent_Class-=({class_id});
				set_equivalent_class(class_id);
			}
	    		foreach (different_From, string class_id)
			{
				different_From-=({class_id});
				set_different_from_class(class_id);
			}
	    }
    }

    
/**
 * <p>Get the Properties where this class acts as range</p>
 * 
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLProperties
 */
    public Visconte.Onto.OWLContainer get_range_properties() 
    {        
       return ontology->get_Items(range_properties);
    } 
    
    
    
/**
 * <p>Get the Properties where this class acts as domain</p>
 * 
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLProperties
 */
    public Visconte.Onto.OWLContainer get_domain_properties() 
    {        
       return ontology->get_Items(domain_properties);
    } 

 
 /**
 * <p>Returns all Domain properties of this class (inherited and self)</p>
 * 
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLProperties
 */
    public Visconte.Onto.OWLContainer get_inherited_domain_properties() 
    {        
     
       
        Visconte.Onto.OWLContainer domains = get_domain_properties() ;
	   if(has_parent())
	   {
		 OWLClass parent  = get_parent();
		 
		 domains->merge(parent->get_inherited_domain_properties());
		   
	   }
          return domains;
    } 
    
/**
 * <p>Returns an array whith the domain ids (only self) </p>
 * 
 * 
 * @return array(string) -- ids
 */
    public array get_property_ids() 
    {        
       return domain_properties;
    } 
    
    
    
/**
 * <p>Returns the classes which are equivalent to this</p>
 * 
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLClass
 */
    public Visconte.Onto.OWLContainer get_equivalent_classes() 
    {        
       return ontology->get_Items(equivalent_Class);
    } 


/**
 * <p>Resets all restrictions of equivalent and different classes.</p>
 * 
 * 
 * @return 
 */
    public void unset_restrictions() 
    {     

	    foreach(equivalent_Class, string id)
		    unset_equivalent_class(id);

	   
	    foreach(different_From, string id)
		    unset_different_from_class(id);
    }
	    
/**
 * <p>Unset a class from the equal state.</p>
 * TODO: Allow OWLClass object as param
 * @param string id of the class
 * @return int
 */
    public int unset_equivalent_class(string id) 
    {    
	    
       if(has_equivalent_class(id))
       {
	       //remove it here
	       int pos = (search(equivalent_Class,id));
	       equivalent_Class-=({equivalent_Class[pos]});
	       ontology->update(this_object());
	       //remove the equivalent_class on the other side of "equal sign"
	       OWLClass mirror_class= ontology->get_Class(id);
	       mirror_class->unset_equivalent_class(this_program::id);
	       ontology->update(mirror_class);
	       return 1; 
       }
       else
	       return 0;
    } 
    
    
/**
 * <p>Set an Class equivalent</p>
 * TODO: Allow OWLClass object as param
 * @param string id of the class
 * @return int 0|1
 */
    public int set_equivalent_class(string id) 
    {    
	    
	    
       //if this item is not in the ontology	    
       if(!ontology->item_exists(this_program::id))
	       return 0;
       //iam always equal myself, no need to mention it
       if(id==this_program::id)
	       return 0;
       if(has_different_from_class(id))
		 unset_different_from_class(id); 

       if(!has_equivalent_class(id))
       {
	        if(ontology->item_exists(id))
		{
			      //add it here;
			      equivalent_Class+=({id});
			      ontology->update(this_object());
			      //add the equivalent_class on the other side of "equal sign"
			      OWLClass mirror_class= ontology->get_Class(id);
			      mirror_class->set_equivalent_class(this_program::id);
			      ontology->update(mirror_class);
			    
		}
		return 1;
       }
       return 0;
    } 
    
    
/**
 * <p>Test if this class is equivaletent to another</p>
 * Note: This is not test euality of two object, rather semantical euivalent
 * TODO: Allow OWLClass object as param
 * @param string id of the class
 * @return int 0|1
 */
    public int has_equivalent_class(string id) 
    {        
       if(search(equivalent_Class,id)>=0)
	       return 1;
       else
	       return 0;
    } 

    
    
/**
 * <p></p>
 * 
 * 
 * @return 
 */
    public int set_different_from_class(string id) 
    {    
	    
	//if this item is not in the ontology	    
       if(!ontology->item_exists(this_program::id)) 
	       return 0;
       //cannot be different from myself
       if(id==this_program::id)
	       return 0;
	if(has_equivalent_class(id))
		 unset_equivalent_class(id); 	    
       if(!has_different_from_class(id))
       {
	       if(ontology->item_exists(id))
	       {
		       //add it here
		       different_From+=({id});
		       ontology->update(this_object());
		       //add the different_from class on the other side of "unequal sign"
		       OWLClass mirror_class= ontology->get_Class(id);
		       mirror_class->set_different_from_class(this_program::id);
		       ontology->update(mirror_class);
		     
	       }

	       
       }
    } 
    
/**
 * <p>Unset a Class differentFrom</p>
 * TODO: Allow OWLClass object as param
 * @param string id of the class
 * @return int 0|1
 */
    public int unset_different_from_class(string id) 
    {    
	    
       if(has_different_from_class(id))
       {
	       //remove it here
	       int pos = (search(different_From,id));
	       different_From-=({ different_From[pos] });
	       ontology->update(this_object());
	       //remove the different_from class on the other side of "unequal sign"
	       OWLClass mirror_class= ontology->get_Class(id);
	       mirror_class->set_different_from_class(this_program::id);
	       ontology->update(mirror_class);
	       
	       return 1;
       }
       else
	       return 0;
    } 
    
/**
 * <p>Tests if a Class differentFrom</p>
 * TODO: Allow OWLClass object as param
 * @param string id of the class
 * @return int 0|1
 */
    public int has_different_from_class(string id) 
    {        
       if(search(different_From,id)>=0)
	       return 1;
       else
	       return 0;
    }       
       
/**
 * <p>Get all Classes which are differentFrom this class</p>
 * Note: This is semantical difference
 * @return Visconte.Onto.OWLContainer - filled with OWLClass objects
 */
    public Visconte.Onto.OWLContainer get_different_from_classes() 
    {        
       return ontology->get_Items(different_From);
    } 
  


  /**
 * <p>Test if this class has child resp subclasses</p>
 * 
 * 
 * @return int 0 or number of childs
 */
    public int has_childs() 
    {        
       return sizeof(childs);
    } 
    
/**
 * <p>Get all direct childs of this class</p>
 * 
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLClass
 */
    public Visconte.Onto.OWLContainer get_childs() 
    {        
       return ontology->get_Items(childs);
    } 


/**
 * <p>Get all childs of the underlying subtree</p>
 * 
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLClass
 */
    public Visconte.Onto.OWLContainer get_all_childs() 
    {      
	    Visconte.Onto.OWLContainer child_container  = Visconte.Onto.OWLContainer();
	    Visconte.Onto.OWLContainer tmp_container  = get_childs();
	    while(tmp_container->has_items())
	    {
		    OWLItem item = tmp_container->next();
		    child_container->add(item);
		    child_container->merge(item->get_all_childs());
	    }
	    return child_container;
    } 
    
/**
 * <p>Test if this it the root class</p>
 * The root class is #Thing
 * 
 * @return int 0|1
 */
    public int is_root() 
    {    
	    if(id=="#Thing" || id=="Thing" || id=="owl:Thing")
		    return 1;
	    else
		    return 0;
    }

    
/**
 * <p>Checkif this class is an descendant of the other class</p>
 * 
 * @param OWLClass|string the class or id  where this is descendant of 
 * @return 0|1
 */
    public int is_descendant_of(OWLClass|string owl_class) 
    {  
	    OWLClass _class = ontology->get_Item(get_Id());
	    OWLClass possible_ancestor;
	    if(stringp(owl_class))
	    {
		    possible_ancestor = ontology->get_Item(owl_class);
	    }
	    else
		    possible_ancestor = owl_class;
	    
	    if(possible_ancestor->is_root())
	    {
		    return 1;
	    }
	    
	    while(_class!=0)
	    {
		    if(possible_ancestor->is_equal(_class) )
		    {
			    return 1;
			    break;
			    
		    }
		    if(_class->is_root())
		    {
			    return 0;
			    break;
		    }
		    
		    _class=_class->get_parent();
	    }
	    return 0;
    }
	    
/**
 * <p>Checks if this class has a parent class</p>
 * Only false if this is the root class
 * 
 * @return 0|1
 */
    public int has_parent() 
    {        
	    if(ontology->item_exists(parent_id) && !is_root())
	    {
		    return 1;
	    }
	    else
		    return 0;
    }
    
/**
 * <p>Get the parent class of this class, if exists</p>
 * Note: This implemenation focus on a single inheritance
 * 
 * @return OWLClass - the parent class
 */
    public OWLClass get_parent() 
    {        
	   if(has_parent())
		    return ontology->get_Class(parent_id);
	   else
		    return 0;
	   
    } 

/**
 * <p>Set a new parent class</p>
 * 
 * 
 * @param OWLClass - the new parent
 */
    public void set_parent(OWLClass parent) 
    {        
	 if(parent->get_Id()==0)
		this_program::parent_id=Visconte.Onto.Ontology.THING;
	 else
		this_program::parent_id=parent->get_Id();
    } 
    
/**
 * <p>Returns all individuals of this branch (up and down)</p>
 * This will retrieve all individuals which are in the branch of this class (from root to the leafes)
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLIndividual
 */
    public Visconte.Onto.OWLContainer get_all_individuals() 
    {
	    Visconte.Onto.OWLContainer ind = get_individuals_up_to_root();
	    ind->merge(get_individuals_down_to_leaf());
	    return ind;
    }
    
/**
 * <p>Get individuals of this class and the parent classes</p>
 * 
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLIndividual 
 */
    public Visconte.Onto.OWLContainer get_individuals_up_to_root() 
    {  
	   Visconte.Onto.OWLContainer ind = get_individuals() ;
	   if(has_parent())
	   {
		 OWLClass parent  = get_parent();
		 
		 ind->merge(parent->get_individuals_up_to_root());
		   
	   }
          return ind;
    } 
    
    
    
    
/**
 * <p>Get individuals of this class and all subclasses</p>
 * 
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLIndividual 
 */
    public Visconte.Onto.OWLContainer get_individuals_down_to_leaf() 
    {  
	   Visconte.Onto.OWLContainer ind = get_individuals() ;
	   if(has_childs())
	   {
		 Visconte.Onto.OWLContainer  child_container = get_childs();
		   while(child_container->has_items())
		   {
			   ind->merge(child_container->next()->get_individuals_down_to_leaf());
		   }  
	   }
          return ind;
    } 
    
    
/**
 * <p>Get individuals of this class only</p>
 * 
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLIndividual 
 */
    public Visconte.Onto.OWLContainer get_individuals() 
    {       
       return ontology->get_Items(individuals);
    } 


/**
 * <p>Get the number of individuals where this class is the template</p>
 * This will return only the number of individuals of this class, not the inherited ones
 * 
 * @return int - count
 */
    public int get_number_of_indivduals() 
    {        
	    return sizeof(individuals);
        
    } 

/**
 * <p>Get the weight of  this class in relation to its depth in the tree level<p>
 * The weight is the addition of all individuals of the subclasses and the number of individuals of this class
 * 
 * @param int add - add this amount to the weight of all classes in the branch
 *	            (usefull within visconte browser for treemap appearance)
 * @return int count 
 */
    public int get_weight(int add) 
    {        
	   
	   int weight = get_number_of_indivduals();
	  
	   if(has_childs())
	   {
		   Visconte.Onto.OWLContainer  child_container = get_childs();
		   while(child_container->has_items())
		   {
			   weight+=child_container->next()->get_weight(add);
		   }
		    return weight;
	   }
	   else
		  return weight+add;
        
    }     

   
} //}}}

/**   
*	I N D I V I D U A L S
* 
* <p>class OWLIndividual - Represents an Instance of a class</p>
* see Comment Header in OWLItem for more details!
*/
class OWLIndividual
{
inherit OWLItem;



/**
 * <p>Represents the type of the item, which is INDIVIDUAL here</p>
 */
    public constant ITEMTYPE = INDIVIDUAL;

/**
 * <p>Represents the id of the model class </p>
 */
    private string class_id;
    
/**
 * <p>Array with all valid properties of this individual</p>
 */
    private Visconte.Onto.OWLContainer properties;
    
    
/**
 * <p>Array with all associations of this individual</p>
 */
    private array association_ids =({});

/**
 * <p>Array with all valid properties of this individual</p>
 */
    private array(array(mixed)) property_map =({});


/**
 * <p>Constructor: creates an OWLIndividual. If you want to create an item which isnt in the ontology, 
 * use the OWLItemFactory to construct the Individual</p>
 * 
 * @param ontology The associated Ontology
 * @param id - the id of the individual
 * @param class_id -the id of the model class
 * @param label - mapping with lang:label items
 * @param properties - the properties which are allowed for this individual (get from model class and its parents)
 * @param property_values - the Visconte.MVList with the id to value(s) statements
 *
 * 
 */
    public void create( Visconte.Onto.Ontology ontology, string id, string class_id, mapping label, Visconte.Onto.OWLContainer properties, Visconte.MVList property_values) 
    {        
	    	this_program::ontology=ontology;
                this_program::id=id;
		this_program::class_id=class_id;
		if(label)
			this_program::label=label;
		this_program::properties = properties;
		//set the property values to the matching property
		if(property_values)
		set_Properties(property_values);
		
    } 
    

/**
 * <p>Checks if this individual is a document term</p>
 * 
 * 
 * @return nothing
 */
    public int is_document_term() 
    { 
	    return this_object()->get_model_class()->is_document_term();
    }
    
 /**
 * <p>Return the obejctid and the mimetype of a document individual</p>
 * 
 * 
 * @return nothing
 */
    public mapping get_steam_properties() 
    { 
	    if(is_document_term())
		    return ontology->get_steam_properties(this_object());
	    else
		    return ([ "objectid" : "-1", "mimetype" : "-1" ]);
    }
    
       
/**
 * <p>Method to set an Visconte.MVList with index:property value pairs to this individual
 * It will call the set_Property method to validate the items</p>
 * 
 * 
 * @return nothing
 */
    public void set_Properties(Visconte.MVList property_values) 
    {     
	  
	    array indexes = property_values->get_indexes();
	    //reset current properties
	   
	    foreach(indexes,string index)
	    {
		    foreach(property_values->get(index), string value)
		    set_Property(index,value);
	    }
    }
/**
 * <p>Returns the model class, from which this individual is derived</p>
 * 
 * 
 * @return the model class as OWLClass
 */
    public OWLClass reset_properties() {
	    association_ids =({});
	    property_map =({});
    }
     
/**
 * <p>Returns the model class, from which this individual is derived</p>
 * 
 * 
 * @return the model class as OWLClass
 */
    public OWLClass get_model_class() {        
	    
	    return ontology->get_Item(class_id);
    } 
    
/**
 * <p>This sets a new model class for this individual</p>
 * 
 * 
 * @param class the new model class
 */
    public void set_model_class(OWLClass owl_class) {        
        
	    this_program::class_id=owl_class->get_Id();
    } 
    
/**
 * <p>This method returns checks for the existence
 * resp. if this property is set.</p>
 * 
 * 
 * @return the multi value property list 
 */
    public int has_property(OWLProperty|string property) 
    {        
        string property_search_id;
 	if(objectp(property))
		property_search_id=property->get_Id();
	else
		property_search_id=property;
	
	foreach(property_map,array prop_value)
	{
		if(prop_value[0]->get_Id()==property_search_id)
			break;
			return 1;
	}
	
	return 0;
    }
    

    
    
/**
 * <p>This method returns the value(s) of a property</p>
 * 
 * 
 * @return array with property definition

    public array get_property(OWLProperty|string property) 
    {        
        string property_id;
 	if(objectp(property))
		property_id=property->get_Id();
	else
		property_id=property;
	
	foreach(property_map,array prop_value)
	{
		if(prop_value[0]->get_ID()==property_search_id)
			break;
			return 1;
	}
	
	return 0;
    }
     */
/**
 * <p>This method returns the Visconte.MVList of properties.</p>
 * 
 * 
 * @return the multi value property list 
 */
    public Visconte.MVList get_property_list() 
    {       
	Visconte.MVList property_mv_list = Visconte.MVList();
	foreach(property_map,array prop_value)
	{
		if(prop_value[0]->ITEMTYPE==Visconte.Onto.Item.OWLItem.OBJECT_PROPERTY)
			property_mv_list->add(prop_value[0]->get_Id(),prop_value[1]->get_Id());
		else
			property_mv_list->add(prop_value[0]->get_Id(),prop_value[1]);
	}
        return property_mv_list;
    } 

/**
* <p>Get OWLContainer with all associated individuals
 * 
 * 
 * @return Visconte.Onto.OWLContainer - filled with OWLIndividuals
 */
    public Visconte.Onto.OWLContainer get_associations() 
    {        
        return ontology->get_Items(association_ids);
    }

/**
* <p>Test if this Individual is associated with the given one
 * 
 * 
 * @return int 0|1
 */
    public int is_associated_with(OWLIndividual|string individual) 
    {        
	    string ind_id;
	    if(objectp(individual))
		ind_id=individual->get_Id();
	    else
		ind_id=individual;
	    
	    if(has_value(association_ids,ind_id))
		    return 1;
	    else
		    return 0;
    }
    
/**
* <p>Remove all associations with the given individual
 * 
 * 
 * @return int 0|1 success 
 */
    public int remove_associations_with(OWLIndividual|string individual) 
    {
	    string ind_id;
	   
	    if(objectp(individual))
		ind_id=individual->get_Id();
	    else
		ind_id=individual;
	    if(is_associated_with(ind_id))
	    {  
		   foreach(property_map,array property_set)
		   {
			   if(property_set[0]->ITEMTYPE==OBJECT_PROPERTY && property_set[1]==ind_id)
				remove_Property(property_set[0]);
		   }
		   
		   return 1;
	    }
	    else
		   return 0;
    }

    /**
* <p>Remove all associations with the given individual
 * 
 * 
 * @return int 0|1 success 
 */
    public int replace_individual(OWLIndividual|string individual, OWLIndividual new_id) 
    {
	    string ind_id;
	    array(array(mixed)) tmp_map =({});
	    if(objectp(individual))
		ind_id=individual->get_Id();
	    else
		ind_id=individual;
	    if(is_associated_with(ind_id))
	    {  
		   foreach(property_map,array property_set)
		   {
			   if(property_set[0]->ITEMTYPE==OBJECT_PROPERTY && property_set[1]==ind_id)
				property_set[1]=new_id->get_Id();
			   tmp_map+=({property_set});
			  
		   }
		   this_program::property_map = tmp_map;
		   return 1;
	    }
	    else
		   return 0;
    }
	
/**
 * <p>This method returns an array with the ordering ({ ({ OWLProperty, (string) value})[0..*] })
 *    used for the xml constuction
 * 
 * 
 * @return the property map as array
 */
    public array get_property_map() 
    {        
        return property_map;
    }
    


/**
 * <p>This method sets a property to the individual
 * <li>First its checks if the propagated id is a valid property for this 
 * individual (by checking for equality of the property domain and the model class of this individual
 * </li>
 * <li>Then it test if the value is an ObjectProperty and if the given value is an existing instance
 * in the ontology. If so, it will be added to the property list and to the property map. The tests for
 * a datatype are similar, except the test for a valid value</p>
 * 
 * 
 * @param id - the id of the property 
 * @param value - either the id of connected individual or a xsd: datatype (depends on property type) 

 */
    public void set_Property(string id, string value) 
    {     
	    OWLItem property;
	    property = this_program::properties->find_by_id(id);
	     
	    //1st test for the existence in the valid properties
	    if(property)
	    {
		    //if its an ObjectProperty, test for a valid individual
		    //and if the model class of the individual is the same
		    // as the range type of the Property
		    if(property->ITEMTYPE==OBJECT_PROPERTY)
		    {
			 if(ontology->item_exists(value))
			 {	
				
				 //get the model class of this individual
				 //get_items_by_subject avoids a ping-pong effect on individuals refering each other  
				  OWLClass model_class = ontology->get_items_by_subject(value,2,CLASS)->next();
				
				 //test for equality of the values modelclass (and its parents) and Property range class
				 // and dont associate with itself
				 if(model_class->is_descendant_of(property->get_range()) && get_Id()!=value)
				 {
					 
					 // add the value to OWLProperty object
					 property_map+=({ ({ property, value}) }); 
					 // add the id to the association_id array
					 association_ids+=({value});
				 }
			 }
		    }
		    //if its a datatype property, proceed here
		    else
		    {
			    //see above...
			    property_map+=({ ({ property, value}) }); 
		    }
	    }		    
	       
	       
    } 

/**
 * <p>Removes an property from the indiviudal,
 * NOTE: it removes all property values which are "derived" from this property
 * If a single index:value pair should be removed, use method: remove_index_value_pair()</p>
 * 
 * @param OWLProperty - the property to remove
 * @return int 0|1 
 */
    public int remove_Property(OWLProperty property) 
    {        
	foreach(property_map,array prop_value)
	{
		if(prop_value[0]->get_Id()==property->get_Id())
			property_map-=({prop_value});
	}
	return 1;
    } 

/**
 * <p>Removes an property from the indiviudal,
 * NOTE: it removes all property values which are "derived" from this property
 * If a single index:value pair should be removed, use method: remove_index_value_pair()</p>
 * 
 * @param OWLProperty - the property to remove
 * @return int 0|1 
 */
    public int replace_Property(OWLProperty old_property, OWLProperty new_property) {        
        
	foreach(property_map,array prop_value)
	{
		if(prop_value[0]->get_Id()==new_property->get_Id())
			property_map-=({prop_value});
			prop_value[0]=new_property;
			property_map+=({prop_value});
	}
	return 1;
    }     
/**
 * <p>This method removes a single index value pair from this individual</p>
 * 
 * 
 * @param property 
 */   
    // public int remove_index_value_pair(string id, string value ) {        
        
	// foreach(property_map,array prop_value)
	// {
	// 	if(property_set[0]->ITEMTYPE==OBJECT_PROPERTY)
	// 	if(prop_value[0]->get_Id()==new_property->get_Id() && property_set[1]==ind_id)
	// 		property_map-=({prop_value});
	// 		prop_value[0]=new_property;
	// 		property_map+=({prop_value});
	// }
    // }
    
    
    
/**
 * <p>This method returns checks for the existence
 * resp. if this property is set.</p>
 * 
 * 
 * @return the multi value property list 
 */
    // public int has_index_value_pair(OWLProperty|string property, string value) 
    // {        
    //     string property_id;
 	// if(objectp(property))
	// 	property_id=property->get_Id();
	// else
	// 	property_id=property;
	// write("has_index_value_pair: ix:"+property_id+", val"+value+"\n");
	//test what type  of property we are testing for
	// OWLProperty index_property = this_program::properties->find_by_id(property_id);
	//if object property modify the id
	// if(index_property->ITEMTYPE==OBJECT_PROPERTY)
			//value = Visconte.Tools()->flat_ID(value);
	
	// return property_mv_list->has_index_value(property_id, value);
    // }    

} //end class OWLIndividual

/**
 * <p>class OWLProperty - This class defines common methods for Object and Datatype Property</p>
 * see Comment Header in OWLItem for more details!
 *
 *
 *
 *
 * 
 */
class OWLProperty
//{{{ 
{
inherit OWLItem;

 
 
/**
 * <p>The bitset used for constraints like semtric propertie and so on</p>
 */
    protected int bitset = 0b00000;

/**
 * <p>The domain of the property, which is in all cases a class</p>
 */
    static  OWLClass domain;


 /**
 * <p>Checks if this property is transitive.</p>
 * 
 * 
 * @return int 0|1 
 */
    public int is_transitive() 
    {        
        if (bitset&0b00001)
		return 1;
	else
		return 0;
    } 

/**
 * <p>Checks if this property is functional.</p>
 * 
 * 
 * @return int 0|1  
 */
    public int is_functional() {        
        if (bitset&0b00010)
		return 1;
	else
		return 0;
    } 

/**
 * <p>Checks if this property is symetric..</p>
 * 
 * 
 * @return int 0|1 
 */
    public int is_symetric() 
    {        
        if (bitset&0b00100)
		return 1;
	else
		return 0;
    } 

/**
 * <p>Checks if this property is inverse of.</p>
 * 
 * 
 * @return int 0|1 
 */
    public int is_inverse_of() 
    {        
        if (bitset&0b01000)
		return 1;
	else
		return 0;
    } 

/**
 * <p>Checks if this property is inverse functional.</p>
 * 
 * 
 * @return int 0|1 
 */
    public int is_inverse_functional() 
    {        
        if (bitset&0b10000)
		return 1;
	else
		return 0;
    } 

/**
 * <p>Set the constraing bitset</p>
 * 0b00000 - default
 * 0b00001 - transitive
 * 0b00010 - functional
 * 0b00100 - symetric
 * 0b10000 - inverse functional
 *
 * Note: up to now this is not function in the ontology script
 * @param bitset 
 */
    public void set_restriction_bitset(int bitset) 
    {        
	    this_program::bitset=bitset;
    } 


/**
 * <p>Set the restriction by a string:int mapping</p>
 * valid indexes and values
 * are (transitive,functional,symetric,inverse,inverse_functional : 0|1)
 * 
 * @param mapping(string:int) - the restrictions
 */
    public void set_restriction(mapping restriction) 
    {        
	    int set=0b00000;
	    if(restriction["transitive"]==1)
		    set|=0b00001;
	    if(restriction["functional"]==1)
		    set|=0b00010;
	    if(restriction["symetric"]==1)
		    set|=0b00100;
	    if(restriction["inverse"]==1)
		    set|=0b01000;
	    if(restriction["inverse_functional"]==1)
		    set|=0b10000;
	    
	    this_program::bitset=set;
	    
	    
    } 
/**
 * <p>Returns the domain of this property</p>
 * 
 * 
 * @return OWLClass - the domain class
 */
    public OWLClass get_domain() {        
       return domain;
    } 
    
    
/**
 * <p>Set a new domain to this property</p>
 * 
 * @param OWLClass - the new domain class
 * @return 
 */
    public OWLClass set_domain(OWLClass domain) {        
       this_program::domain = domain;
    } 


    
/**
 * <p>Returns all individuals with this property (individuals of the domain)</p>
 * This will do the same like the method get_individuals_down_to_leaf() in OWLClass
 * 
 * @return 
 */
    public Visconte.Onto.OWLContainer get_individuals() 
    {        
        return domain->get_individuals_down_to_leaf();
    } 



} //}}}




/**
 * <p>class OWLObjectProperty - Represents an OWL ObjectProperty, which is also named an association in this library</p>
 * see Comment Header in OWLItem for more details!
 */
class OWLObjectProperty
//{{{ 
{
inherit OWLProperty;

/**
 * <p>Represents the type of the item, which is CLASS here</p>
 */
    public constant ITEMTYPE = OBJECT_PROPERTY;

    
/**
 * <p>The Range class of this object</p>
 */
    private  OWLClass range;
    
    
    
/**
 * <p>Construct an ObjectProperty</p>
 * @param ontology - the ontology object to operate on
 * @param id - the id of this Object Property
 * @param restrictions - a mapping with the restrictions (see set_restriction() in OWLProperty)
 * @param mapping label - the label or name of this property
 * @param OWLClass domain - the domain of this property
 * @param OWLClass range - the range of this property
 * @return 
 */
 
   public void create(Visconte.Onto.Ontology ontology, string id,  mapping restriction, mapping label, OWLClass domain, OWLClass range)
   {
	   this_program::ontology=ontology;
	   this_program::id=id;
	   this_program::label=label;
	   set_restriction(restriction);
	   this_program::domain=domain;
	   this_program::range=range;
	   
	       
   }
   
/**
 * <p>Get the range Class of this property</p>
 * 
 * @return OWLClass - the range class
 */
    public OWLClass get_range() {        
        return range;
    } 
    
/**
 * <p>Set a new Range class</p>
 * 
 * @param OWLClass - the new range
 */
    public int set_range(OWLItem range) {        
        this_program::range=range;
    }


} //}}}



/**
 * <p>class OWLDataytypeProperty -Represents an OWL Datatype</p>
 * see Comment Header in OWLItem for more details!
 */
class OWLDatatypeProperty
//{{{ 
{
inherit OWLProperty;




/**
 * <p>Represents the type of the item, which is CLASS here</p>
 */
    public constant ITEMTYPE = DATATYPE_PROPERTY;

/**
 * <p>The range as string rpresentaion which is an xsd element (e.g string, anyURI etc.)</p>
 */
    private  string range;

/**
 * <p>If no dataytype is specified use (xsd:)string</p>
 */
    private  string default_dataype="string";
    
/**
 * <p>List of valid datatypes</p>
 */
    private array datatypes = ({"string",
				"normalizedString",
				"boolean",
				"decimal",
				"float",
				"double",
				"integer",
				"nonNegativeInteger",
				"positiveInteger",
				"nonPositiveInteger",
				"negativeInteger",
				"long",
				"int",
				"short",
				"byte",
				"unsignedLong",
				"unsignedInt",
				"unsignedShort",
				"unsignedByte",
				"hexBinary",
				"base64Binary",
				"dateTime",
				"time",
				"date",
				"gYearMonth",
				"gYear",
				"gMonthDay",
				"gDay",
				"gMonth",
				"anyURI",
				"token",
				"language",
				"NMTOKEN",
				"Name",
				"steamDoc",
				"steamUser",
				"steamGroup",
				"steamContainer",
    			      });
    

/**
 * <p>Construct a Datatype Property</p>
 * @param ontology - the ontology object to operate on
 * @param id - the id of this Datatype Property
 * @param restrictions - a mapping with the restrictions (see set_restriction() in OWLProperty)
 * @param mapping label - the label or name of this property
 * @param OWLClass domain - the domain of this property
 * @param string range - the range of this property (xsd element, with or without trailing xsd:)
 * @return 
 */
 
   public void create(Visconte.Onto.Ontology ontology, string id,  mapping restriction, mapping label, OWLClass domain, string range)
   {
	   this_program::ontology=ontology;
	   this_program::id=id;
	   this_program::label=label;
	   set_restriction(restriction);
	   validate_datatype(range);
	   this_program::domain=domain;
	   
	       
   }

/**
 * <p>Returns the range </p>
 * 
 * @return string range 
 */
    public string get_range() {        
        return range;
    } 
/**
 * <p>Set a new range</p>
 * 
 * @param string range - xsd element, with or without trailing xsd:
 */
    public int set_range(string range) {        
        validate_datatype(range);
    } 
    
    
    
/**
 * <p>Validates it the range is valid</p>
 * If its not valid set to default_dataype 
 * 
 */
   private void validate_datatype(string datatype)
   {
	   //if the type has dataype xsd namepace set to string
	   if(!has_prefix(datatype,"xsd:"))
		   this_program::range =  default_dataype;
	   else
	   {
		   //try to find the datatype, else set to string
		  int type = search(datatypes,datatype[4..]);
		  if(type>=0)
			  this_program::range=datatypes[type];
		  else
			  this_program::range=default_dataype;
	   }
   }

} //}}}

