/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen                                 *
 *   kde.sch@ttgen.net                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef CLOCKPAINTVIEW_H
#define CLOCKPAINTVIEW_H

#include <qgl.h>
#include <qimage.h>
#include <kjs/value.h>
#include <kjs/object.h>
#include <list>
#include <map>
#include <qdatetime.h>
#include <dcopobject.h>

namespace KJS {
    class Interpreter;
}
class QTimer;
class ECMAFunc;
class Prefs;
class ClockAppInterface;
class KDirWatch;
class DebugDialog;
class KDialogBase;

/**
@author Fred Schaettgen
*/
class ClockPaintView : public QGLWidget, virtual public DCOPObject
{
    Q_OBJECT

public:
    ClockPaintView(QWidget* parent, ClockAppInterface* iface, Prefs* prefs);
    virtual ~ClockPaintView();
    void reloadSettings();
    QStringList getAvailableThemes();
    int heightForWidth(int width);
    int widthForHeight(int height);
    void updateClock();
    QString currentTheme();
    std::map<QString, QString> currentThemeProperties();
    void setProperty(QString theme, QString property, QString val);
    void setDebugMode(bool b);
    
protected:
    Prefs* prefs;
    KJS::Number envSeconds;
    KJS::Number envMinutes;
    KJS::Number envHours;
    ECMAFunc* defineLayerFunc;
    ECMAFunc* getColorFunc;
    KJS::Object globalObject;
    
    void initializeGL();
    void resizeGL(int w, int h);
    void paintGL();
    int loadTexture(QString filename);
    QString expandFilename(const QString& s);
    void setTheme(const QString& string);
    //virtual void mousePressEvent(QMouseEvent *e);
    void executeScript(bool defineScreenSize);
    KJS::Object createColorObject(KJS::ExecState* state, double r, double g, double b);
    
    struct DisplayListItem
    {
        DisplayListItem(QString imageName);
        ~DisplayListItem();
        QString imageName;
        KJS::Object properties;
    };
    std::list<DisplayListItem> displayList;
    std::map<QString, int> imageMap;
    int screenWidth;
    int screenHeight;
        
    QTimer* timer;
    KJS::Interpreter *interpreter;
    QString script;
    QString themeName;
    std::map<QString, QString> themeProperties;
    
    bool showSeconds;
    bool showDate;
    QString lastDateString;
    GLuint bgTexName;
    ClockAppInterface* owner;
    QTime lastRedrawTime;
    KDirWatch* dirWatch;
    bool debugMode;
    KDialogBase* debugDialogFrame;
    DebugDialog* debugDialog;
        
private slots:
    void ecmaSlotDefineLayer(KJS::ExecState *, KJS::Object &, 
        const KJS::List &args, KJS::Value &ret);
    void ecmaSlotGetColor(KJS::ExecState *, KJS::Object &, 
        const KJS::List &args, KJS::Value &ret);
    void slotTimeout();
    void slotThemeModified();
    void slotThemeModifiedAndWait();
    void slotDebugDialogChanged();

    
signals:
    void sizeSuggestionChanged();
};



#endif
