/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_ACTIONSTORAGE_H
#define _SC_ACTIONSTORAGE_H

// qt
class QAction;
class QWidget;


const long ActionNull = 0xffff;

/**
 * Utility class to store and handle QActions.
 */
class ActionStorage
{
public:
  ActionStorage();
  ~ActionStorage();

  QAction* getAction( long key );
  void     addAction( long key, QAction* action );

  void enableAction( long, bool );
  void enableActions();
  void disableActions();

  void enableActions( long keys[] );
  void disableActions( long keys[] );

private:
  class Member;

  Member* _m;
};

#endif // _SC_ACTIONSTORAGE_H
