/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGRAPHDIALOG_H
#define _SC_LOGGRAPHDIALOG_H

// sc
#include "util/String.h"
class LogGraphCanvasView;
class LogGraphBatonImpl;
class BaseModel;
class Project;

// qt
#include <qwidget.h>
class QWheelEvent;
class QPushButton;
class QLabel;

// sys
#include <vector>

/**
 * Dialog class for displaying log messages information graphical.
 */
class LogGraphDialog : public QWidget
{
  typedef QWidget super;
  Q_OBJECT 

public:
  LogGraphDialog( BaseModel* model, const Project* prj, const sc::String& src,
    bool folder, QWidget *parent = 0 );
  virtual ~LogGraphDialog();

  void wheelEvent( QWheelEvent* e );

  void run();

public slots:
    void diff();
    void diffable(bool);

private:
  BaseModel*       _model;
  const Project*   _prj;

  sc::String       _source;
  bool             _folder; // _source is a folder?

  LogGraphCanvasView* _view;
  LogGraphBatonImpl*  _baton;

  QLabel*             _zoom;
  QPushButton*        _diff;
  QPushButton*        _done;
};

#endif // _SC_LOGGRAPHDIALOG_H
