/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REVISIONWIDGET_H
#define _SC_REVISIONWIDGET_H

// sc
class RevisionProvider;
namespace svn
{
  class Revision;
}

// qt
#include <qgroupbox.h>
class QComboBox;
class QSpinBox;
class QDateTimeEdit;
class ExternButton;
class QWidgetStack;
class QPopupMenu;
class QCheckBox;
class QToolButton;
class QHBox;


class RevisionWidget : public QGroupBox
{
  typedef QGroupBox super;
  Q_OBJECT 

public:
  /**
   * construct a RevisionWidget.
   * @param types     combination of "S"ymbolic, "N"umeric and "D"ate
   * @param symbols   combination of "H"ead, "B"ase, "C"ommitted, "P"revious,
   *                  "W"orking
   */

  RevisionWidget( bool allowNoRevision, const QString& types, const QString& symbols,
    RevisionProvider* prov, QWidget *parent );
  virtual ~RevisionWidget();

  svn::Revision* getRevision() const;
  void setRevision( const svn::Revision* );

private slots:
  void toggled( bool );
  void popup();

private:
  void addType( const QChar& );
  void addSymbol( const QChar& );

private:
  QCheckBox*        _disable;
  QWidgetStack*     _stack;
  QComboBox*        _symRev;
  QSpinBox*         _numRev;
  QDateTimeEdit*    _dateRev;
  QToolButton*      _menuButton;
  QPopupMenu*       _menu;
  QHBox*            _revBox;

  ExternButton*     _extern;
  RevisionProvider* _revpro;
};


#endif // _SC_REVISIONWIDGET_H
