/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "SslServerTrustPromptDialog.h"
#include "sublib/Utility.h"
#include "svn/Client.h"

// qt
#include <qlayout.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qgroupbox.h>



SslServerTrustPromptDialog::SslServerTrustPromptDialog( const char* realm,
  unsigned long failures, const svn::AuthPromptProvider::sslServerCertInfo& certinfo,
  bool maySave, QWidget *parent, const char *name )
: super( parent, name, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu ), _save(false)
{
  _failures = failures;
  setCaption( _q("subcommander:prompt (ssl server trust)") );

  QHBoxLayout *vbl = new QHBoxLayout(this,5,8);
  {
    QVBoxLayout* vl = new QVBoxLayout;
    vbl->addLayout(vl);
    {
      QLabel* icon = new QLabel(this);
      icon->setMargin( 10 );
      icon->setPixmap( QPixmap(getIconDir() + "MessageBox-Warning.png") );
      vl->addWidget(icon);
      vl->addStretch(1);
    }

    QVBoxLayout* vr = new QVBoxLayout;
    vbl->addLayout(vr);
    {
      QGroupBox* gb = new QGroupBox(10,Qt::Vertical,this);
      gb->setTitle( _q("error validating server certificate: ") );
      gb->setInsideSpacing(5);
      gb->setInsideMargin(10);
      gb->setFlat(true);
      gb->setSizePolicy( QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding) );
      vr->addWidget(gb);
      {
        QLabel *r = new QLabel( realm , gb );
        r->setAlignment( Qt::AlignHCenter | Qt::AlignHCenter );

        QLabel* si = new QLabel( gb );
        QString siText =
          "<qt>"
           "<table border=0 width=100% cellspacing=0 cellpadding=0>"
            "<tr>"
            "<td align=right>Hostname:</td>"
             "<td>" +QString(certinfo.hostname)+ "</td>"
            "</tr>"
            "<tr>"
             "<td align=right>Fingerprint:</td>"
             "<td>" +QString(certinfo.fingerprint)+ "</td>"
            "</tr>"
            "<tr>"
             "<td align=right>Issuer:</td>"
             "<td>" +QString(certinfo.issuerDName)+ "</td>"
            "</tr>"
            "<tr>"
             "<td align=right>valid from:</td>"
             "<td>" +QString(certinfo.validFrom)+ "</td>"
            "</tr>"
            "<tr>"
             "<td align=right>valid until:</td>"
             "<td>" +QString(certinfo.validUntil)+ "</td>"
            "</tr>"
           "</table>"
          "</qt>";
        si->setText(siText);


        if( failures & SVN_AUTH_SSL_UNKNOWNCA )
        {
          QLabel *l = new QLabel( gb );
          l->setText( _q("the certificate was not issued by a trusted authority!") );
          l->setAlignment( Qt::AlignHCenter | Qt::AlignHCenter );
          l->setPaletteBackgroundColor( QColor(255,120,120) );
        }
        if( failures & SVN_AUTH_SSL_CNMISMATCH )
        {
          QLabel *l = new QLabel( gb );
          l->setText( _q("the certificate hostname does not match!") );
          l->setAlignment( Qt::AlignHCenter | Qt::AlignHCenter );
          l->setPaletteBackgroundColor( QColor(255,120,120) );
        }
        if( failures & SVN_AUTH_SSL_EXPIRED )
        {
          QLabel *l = new QLabel( gb );
          l->setText( _q("the certificate is no longer valid!") );
          l->setAlignment( Qt::AlignHCenter | Qt::AlignHCenter );
          l->setPaletteBackgroundColor( QColor(255,120,120) );
        }
        if( failures & SVN_AUTH_SSL_NOTYETVALID )
        {
          QLabel *l = new QLabel( gb );
          l->setText( _q("the certificate is not yet valid!") );
          l->setAlignment( Qt::AlignHCenter | Qt::AlignHCenter );
          l->setPaletteBackgroundColor( QColor(255,120,120) );
        }
        if( failures & SVN_AUTH_SSL_OTHER )
        {
          QLabel *l = new QLabel( gb );
          l->setText( _q("the certificate has an unknown error!") );
          l->setAlignment( Qt::AlignHCenter | Qt::AlignHCenter );
          l->setPaletteBackgroundColor( QColor(255,120,120) );
        }
      }

      QHBoxLayout* hu = new QHBoxLayout;
      vr->addLayout(hu);
      {
        hu->addStretch(1);

        if( maySave )
        {
          QPushButton* ap = new QPushButton(this);
          ap->setText( _q("Accept &permanently") );
          hu->addWidget(ap);

          connect( ap, SIGNAL(clicked()), SLOT(acceptPermanently()) );
        }

        QPushButton* at = new QPushButton(this);
        at->setText( _q("Accept &temporarily") );
        hu->addWidget(at);
        QPushButton* r = new QPushButton(this);
        r->setText( _q("&Reject") );
        hu->addWidget(r);

        connect( at, SIGNAL(clicked()), SLOT(acceptTemporarily()) );
        connect( r,  SIGNAL(clicked()), SLOT(reject()) );
      }
    }
  }

  setMaximumHeight( sizeHint().height() );
  setMaximumWidth( sizeHint().width() );
}

SslServerTrustPromptDialog::~SslServerTrustPromptDialog()
{
}


void SslServerTrustPromptDialog::acceptPermanently()
{
  _save = true;
  done(Accepted);
}

void SslServerTrustPromptDialog::acceptTemporarily()
{
  _save = false;
  done(Accepted);
}

void SslServerTrustPromptDialog::reject()
{
  _save = false;
  done(Rejected);
}

unsigned long SslServerTrustPromptDialog::getFailures() const
{
  return _failures;
}

bool SslServerTrustPromptDialog::getSave() const
{
  return _save;
}
