/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CatCmd.h"
#include "CatParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"


CatCmd::CatCmd( CatParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

CatCmd::~CatCmd()
{
  delete _cb;
}

void CatCmd::run()
{
  sc::Error* err;

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->cat( _param->getValue(), _param->getPathOrUrl(), *_param->getRevision() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
