/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COMMITPARAM_H
#define _SC_COMMITPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/ClientTypes.h"
#include "svn/CommitInfo.h"
#include "svn/CommitBaton.h"

/**
 * Parameter class for CommitCmd.
 */
class CommitParam : public ScParam
{
public:
  CommitParam( const svn::Paths& paths, bool recurse, bool keepLocks,
    svn::CommitBaton* baton )
    : _paths(paths), _recurse(recurse), _keepLocks(keepLocks), _baton(baton)
  {
  }

  const svn::Paths& getPaths() const
  {
    return _paths;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  bool getKeepLocks() const
  {
    return _keepLocks;
  }

  svn::CommitBaton* getBaton()
  {
    return _baton;
  }

  svn::CommitInfo& getInfo()
  {
    return _info;
  }
  
  ScParamAccept(CommitParam);

private:
  // in
  svn::Paths        _paths;
  bool              _recurse;
  bool              _keepLocks;
  svn::CommitBaton* _baton;

  // out
  svn::CommitInfo   _info;
};

#endif // _SC_COMMITPARAM_H
