/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _LINE_H
#define _LINE_H

#include "ConflictType.h"
#include "util/String.h"

/**
 * line class for text widget.
 *
 * \todo replace ConflictType with a type object so we don't have
 * the diff stuff hardcoded.
 */
class Line
{
public:
  Line();
  Line( const Line& );
  Line( const sc::String& s, int blockNumber, ConflictType type );

  const sc::String& getLine() const;
  const char*   getStr() const;
  size_t        getChars() const;
  size_t        getBytes() const;

  int           getBlockNr() const;
  ConflictType  getType() const;

  bool          isEmpty() const;
  bool          isDifference() const;

  static const Line& getEmpty();
  static const Line& getEmpty2();

private:
  sc::String    _line;
  int           _blockNumber;
  ConflictType  _type;

  static Line   _empty;
  static Line   _empty2;
};

#endif // _LINE_H

