/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CommandArgs.h"

// apr
#include <apr_strings.h>


CommandArgs::CommandArgs( const sc::String& pattern, apr_pool_t* pool )
: _pool(pool)
{
  _path = ".";
  char* cpat = apr_pstrdup( _pool, (const char*)pattern );
  apr_status_t status = apr_tokenize_to_argv( cpat, &_args, _pool );
}

void CommandArgs::setArg( const sc::String& key, const sc::String& value )
{
  int i = 0;
  while( _args[i] )
  {
    if( key == sc::String(_args[i]) )
    {
      _args[i] = apr_pstrdup( _pool, (const char*)value );
      return;
    }

    i++;
  }
}

const sc::String& CommandArgs::getPath() const
{
  return _path;
}

char** CommandArgs::getArgs() const
{
  return _args;
}
