#-*- perl -*-
package SUFARY;
require 5.000;
#======================================================================
#  = array  - Suffix Array Υƥȸ = 
#                                          Perl Module version
#
#                                            written by T.Nakayama
#======================================================================
require DynaLoader;
@ISA = qw(DynaLoader);
$SUF_MAX = -1;

# 󥹥ȥ饯
sub new {
    my ($class,$textfile,$aryfile) = @_;
    my $self = {};
    bless $self, $class;

    if (++$SUF_MAX >= 256) { return undef; }

    $self->{'id'} = $SUF_MAX;

    if (defined $textfile) {
	if (!(defined $aryfile)) {
	    $aryfile = $textfile . '.ary';
	}
	if (!suf_openfile($self->{'id'}, $textfile, $aryfile)) {
	    return undef;
	}
	$self->{'textfile'} = $textfile;
	$self->{'aryfile'}  = $aryfile;
    }
    # ץν
    $self->{'option'}{'ignore-conj-order'} = 1;
    return $self;
}
# եκƥץ
sub reopen {
    my ($self,$textfile,$aryfile) = @_;

    if (!(defined $textfile)) {$textfile = $self->{'textfile'}}
    if (!(defined $aryfile))  {$aryfile  = $textfile . ".ary"}
    
    if (suf_openfile($self->{'id'}, $textfile, $aryfile)) {
	return 1;
    } else {
	return 0;
    }
}
# եĤ
sub close {
    my $self = shift;

    suf_closefile($self->{'id'});
}
# 
sub search0 {
    my ($self,$key) = @_;
    
    my $id = $self->{'id'};

    undef @{$self->{'result'}};

    my @ret =  suf_search($id, $key);
    if ($#ret != 1) {
	$self->{'left'} = 0;
	$self->{'right'} = -1;
    } else {
	$self->{'left'} = $ret[0];
	$self->{'right'} = $ret[1];
    }
    $self->{'match_num'} = $self->{'right'} - $self->{'left'} + 1;
    return $self->{'match_num'};
}
#  array ν
sub init {
    my ($self) = @_;
    
    suf_init($self->{'id'});

    undef @{$self->{'result'}};
}
# init + search0
sub search {
    my $self = shift;
    my ($key) = @_;

    $self->init;
    return $self->search0($key);
}
# ޥåԤν
sub line {
    my ($self,$num) = @_;

    return undef if ($num >= $self->{'match_num'});


    if (!defined $self->{'result'}[$num]) {
	 $self->{'result'}[$num] =
	     suf_aidx2tidx($self->{'id'}, $num + $self->{'left'});
    }
    my $ret = suf_getline($self->{'id'}, $self->{'result'}[$num]);
    return $ret;
}
# ޥåԤ ID 
sub lid {
    my ($self,$num) = @_;

    return undef if ($num >= $self->{'match_num'}||$num < 0);

    if (!defined $self->{'result'}[$num]) {
	 $self->{'result'}[$num] =
	     suf_aidx2tidx($self->{'id'}, $num + $self->{'left'});
    }
    suf_line_top_id($self->{'id'}, $self->{'result'}[$num]);
}
# PID 2 LID
sub pid2lid {
    my ($self,$pid) = @_;

    return suf_line_top_id($self->{'id'}, $pid);
}
# ƤθޥåԤν
sub get_all_line {
    my ($self) = @_;
    my ($num,$pos,$ret);
    my @buf;
    for ($num = 0; $num < $self->{'match_num'}; $num++) {
	push(@buf,$self->line($num));
    }
    return \@buf;
}
# ƤθޥåԤ ID 
sub get_all_lid {
    my ($self) = @_;
    my ($num,$pos,$ret);
    my @buf;
    for ($num = 0; $num < $self->{'match_num'}; $num++) {
	push(@buf,$self->lid($num));
    }
    return \@buf;
}
# Ƥθޥå PID 
sub get_all_pos {
    my ($self) = @_;
    my ($num);
    for ($num = 0; $num < $self->{'match_num'}; $num++) {
	$self->{'result'}[$num] =
	    suf_aidx2tidx($self->{'id'}, $num + $self->{'left'});
    }
    return $self->{'result'};
}
# ޥå PID 
sub pos {
    my ($self,$num) = @_;

    return undef if ($num >= $self->{'match_num'} || $num < 0);

    if (!defined($self->{'result'}[$num])) {
	$self->{'result'}[$num] =
	    suf_aidx2tidx($self->{'id'}, $num + $self->{'left'});
    }
    return $self->{'result'}[$num];
}
# ID -> line
sub id2line {
    my ($self,$pos) = @_;

    my $ret = suf_getline($self->{'id'}, $pos);
    return $ret;
}
# ץ
sub opt {
    my ($self,$opt,$val) = @_;

    $self->{'option'}{$opt} = $val;
}

# ֥å
sub get_block {
    my ($self,$pos,$d1,$d2) = @_;

    my $ret = suf_block($self->{'id'}, $pos, $d1, $d2);
    return $ret;
}

# 
sub common_prefix {
    my ($self,$key,$sep) = @_;

    &SUFARY::init;
    
    my @ret = suf_common_prefix_search($self->{'id'}, $key, $sep);
    return \@ret;
}

#
sub getstr {
    my ($self, $from, $size) = @_;
    return suf_getstr($self->{'id'},$from,$size);
}

bootstrap SUFARY;
1;
