/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FRMCONFIG_H
#define FRMCONFIG_H

#include "dlgConfig.h"
#include "swsconfig.h"

#include <iostream>

#include <klocale.h>
#include <kiconloader.h>
#include <kdialogbase.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include <qsqldatabase.h>
#include <qlineedit.h>
#include <qsqldatabase.h>
#include <qgroupbox.h>
#include <qcombobox.h>
#include <qstringlist.h>
#include <qsqlquery.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qsqlerror.h>
#include <qsqlcursor.h>
#include <qpushbutton.h>
#include <qvalidator.h>

using namespace std;

class frmconfig : public KDialogBase {
Q_OBJECT
	
	QSqlDatabase *	db;	
	dlgConfig *	d; 	// Main widget	

	bool Configured;	
	
public:
        frmconfig(QWidget* parent = 0, const char* name = 0, bool modal = true);
        ~frmconfig();

	/*$PUBLIC_FUNCTIONS$*/
	bool configureConnection();
	bool isConfigured(QString essid, QString mac);
	void removeConfig(QString essid, QString mac);
	void loadConfiguration(QString essid, QString mac);
	bool isGrouped(QString essid);
	
	QLabel * getlblEssid() { return d->lblEssid; };
	QLabel * getlblMAC() { return d->lblMAC; };
	QCheckBox * getchkWEP() { return d->chkWEP; };
	QLineEdit * gettxtKey() { return d->txtKey; };
	QComboBox * getcmbKeyLength() { return d->cmbKeyLength; };
	QLineEdit * gettxtIP1() { return d->txtIP1; };
	QLineEdit * gettxtIP2() { return d->txtIP2; };
	QLineEdit * gettxtIP3() { return d->txtIP3; };
	QLineEdit * gettxtIP4() { return d->txtIP4; };
	QLineEdit * gettxtMask1() { return d->txtMask1; };
	QLineEdit * gettxtMask2() { return d->txtMask2; };
	QLineEdit * gettxtMask3() { return d->txtMask3; };
	QLineEdit * gettxtMask4() { return d->txtMask4; };
	QLineEdit * gettxtGat1() { return d->txtGat1; };
	QLineEdit * gettxtGat2() { return d->txtGat2; };
	QLineEdit * gettxtGat3() { return d->txtGat3; };
	QLineEdit * gettxtGat4() { return d->txtGat4; };
	QGroupBox * getfrmGate() { return d->frmGate; };
	QGroupBox * getfrmDhcp() { return d->frmDhcp; };
	QLineEdit * gettxtDhcpClient() { return d->txtDhcpClient; };
	QLineEdit * gettxtScript() { return d->txtScript; };
	
	
public slots:
        /*$PUBLIC_SLOTS$*/
	void	enableWEP(int);	
	void	statSelected(bool);
	void	dhcpSelected(bool);
	void	keyLengthSel();
	void	slotUser1();
	void	findScript();

protected:
        /*$PROTECTED_FUNCTIONS$*/

protected slots:
        /*$PROTECTED_SLOTS$*/

};

#endif

