/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mainwindow.h"
#include "frmconfigini.h"

frmConfigIni::frmConfigIni(QWidget* parent, const char* name, bool modal)
	: KDialogBase( parent, name, modal, i18n("General Settings"), Cancel|Apply, Cancel )
{
	int i, databits, stop;
	QString baud, parity, speedunits;

	d = new dlgConfigIni(this); 
	this->setMainWidget(d);

	setButtonGuiItem(Apply, KGuiItem(i18n("Save"), "filesave"));
	
	baud = QVariant(conf.getBaud()).toString();
	parity = conf.getParity();
	databits = conf.getDataBits();
	stop = conf.getStopBits();
	speedunits = conf.getSpeedUnits();

	for (i=0;i < d->cmbBaud->count();i++)
		if ( d->cmbBaud->text(i) == baud )
			d->cmbBaud->setCurrentItem(i);
			
	for (i=0;i < d->cmbParity->count();i++)
		if ( d->cmbParity->text(i).left(1) == parity )
			d->cmbParity->setCurrentItem(i);

	for (i=0;i < d->cmbBits->count();i++)
		if ( d->cmbBits->text(i) == QVariant(databits).toString() )
			d->cmbBits->setCurrentItem(i);
			
	for (i=0;i < d->cmbStop->count();i++)
		if ( d->cmbStop->text(i) == QVariant(stop).toString() )
			d->cmbStop->setCurrentItem(i);	
	
	d->txtDHCP->setText(conf.getDhclient());
	d->txtDevice->setText(conf.getSerialDev());
	d->txtIface->setText(conf.getDefIface());
	d->txtTerminal->setText(conf.getTerminal());
	d->txtFileOpen->setText(conf.getFileToOpen());

	d->btnFindDHCP->setPixmap(SmallIcon("fileopen"));
	d->btnFindDevice->setPixmap(SmallIcon("fileopen"));
	d->btnFindTerminal->setPixmap(SmallIcon("fileopen"));
	d->btnFindFile->setPixmap(SmallIcon("fileopen"));

	d->chkStartup->setChecked (conf.getStartScanning());
	d->chkTerminal->setChecked (conf.getUseTerminal());
	chkTerminalChanged (d->chkTerminal->isChecked());

	if (speedunits == "kph")
		d->cmbSpeedUnits->setCurrentItem(0);
	else if (speedunits == "mph")
		d->cmbSpeedUnits->setCurrentItem(1);
	else
		d->cmbSpeedUnits->setCurrentItem(2);

	connect( d->btnFindDHCP, SIGNAL( clicked() ), this, SLOT( findDHCP() ) );
	connect( d->btnFindTerminal, SIGNAL( clicked() ), this, SLOT( findTerminal() ) );
	connect( d->btnFindDevice, SIGNAL( clicked() ), this, SLOT( findDevice() ) );
	connect( d->btnFindFile, SIGNAL( clicked() ), this, SLOT( findFile() ) );

}

frmConfigIni::~frmConfigIni()
{
	qDebug("Deleting frmConfigIni...");
	delete d;
}

/*$SPECIALIZATION$*/
void frmConfigIni::slotApply()
{
	QLabel * lblSpeedUnits = (QLabel*)parent()->child("lblSpeedUnits");

	if (d->txtDHCP->text() == "" || d->txtDevice->text() == "" || d->txtTerminal->text() == "")
	{
		KMessageBox::information( this, i18n("Can't save incomplete data."));
		return;
	}
	
	conf.setBaud(d->cmbBaud->currentText().toInt());
	conf.setDataBits(d->cmbBits->currentText().toInt());
	conf.setStopBits(d->cmbStop->currentText().toInt());
	switch(d->cmbParity->currentItem())
	{
		case 0: conf.setParity("E"); break;
		case 1: conf.setParity("O"); break;
		case 2: conf.setParity("N"); break;
	}
	switch(d->cmbSpeedUnits->currentItem())
	{
		case 0: conf.setSpeedUnits("kph");
			lblSpeedUnits->setText( i18n( "Speed (km/h):" ) );
			break;
		case 1: conf.setSpeedUnits("mph");
			lblSpeedUnits->setText( i18n( "Speed (mi/h):" ) );
			break;
		case 2: conf.setSpeedUnits("kno"); 
			lblSpeedUnits->setText( i18n( "Speed (knots):" ) );
			break;
	}
	conf.setDhclient( d->txtDHCP->text() );
	conf.setSerialDev( d->txtDevice->text() );
	conf.setDefIface( d->txtIface->text() );
	conf.setStartScanning( d->chkStartup->isChecked() );
	conf.setUseTerminal( d->chkTerminal->isChecked() );
	conf.setTerminal( d->txtTerminal->text() );
	conf.setFileToOpen( d->txtFileOpen->text().stripWhiteSpace() );

	//conf.WriteCFG();
	KMessageBox::information( this, i18n("Configuration successfully updated"));
	
	frmConfigIni::close();
}

void frmConfigIni::findDevice()
{
	QString device = KFileDialog::getOpenFileName(
		"/dev",
        	QString::null,
		this,
		i18n("Choose your serial device"));
	if (device=="") return;
	d->txtDevice->setText(device);
}

void frmConfigIni::findFile()
{
	QString fileName = KFileDialog::getOpenFileName(
			":<swsfiles>", 
			"*.sws|" + i18n("SWScanner files") + " (*.sws) \n *.nsf|" + i18n("NetStumbler Summary files") + " (*.nsf)",
			this,
			i18n("Open file dialog"));

	if (fileName == "") return;
	d->txtFileOpen->setText(fileName);
}

void frmConfigIni::findDHCP()
{
	QString filename = KFileDialog::getOpenFileName(
		QString::null,
        	QString::null,
		this,
		i18n("Choose your dhcp client binary"));
	if (filename=="") return;
	d->txtDHCP->setText(filename);
}

void frmConfigIni::findTerminal()
{
	QString filename = KFileDialog::getOpenFileName(
		QString::null,
        	QString::null,
		this,
		i18n("Choose your favorite x-terminal"));
	if (filename=="") return;
	d->txtTerminal->setText(filename);
}
void frmConfigIni::chkTerminalChanged(bool checked)
{
	if (checked)
	{
		d->txtTerminal->setEnabled(true);
		d->btnFindTerminal->setEnabled(true);
	} else 
	{
		d->txtTerminal->setEnabled(false);
		d->btnFindTerminal->setEnabled(false);
	}	
}

#include "frmconfigini.moc"

