# PlaylistParserRhythmbox.py 
#  
#  Copyright (c) 2005 INdT (Instituto Nokia de Technologia)
#  
#  Author: Kenneth Rohde Christiansen <kenneth.christiansen@gmail.com>
# 
#  This program is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU General Public License as 
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA

import urllib
import pyid3lib
import os
import sys
import gtk
from elementtree.ElementTree import ElementTree
import Utils

def parse_playlists(path):
	playlists = []
	songs = []
	playlist_size = 0
	playlist_name = u"Unknown"
	is_static = False

	path = os.path.expanduser(path) 
	
	root = ElementTree(file=path)

	iter = root.getiterator()

	for element in iter:

    		if element.tag == "playlist":
     			is_static = False

    			if element.keys():
        			for name, value in element.items():
	        			if name == "type" and value == "static":
	    	    				is_static = True
	        			if name == "name":
		    				temp_name = value

        		if is_static == True: # new playlist found
	    			playlist_name = temp_name
				playlist_size = 0
				songs = []

				playlists.append( [playlist_name, playlist_size, songs] )

    		#Text that precedes all child elements (may be None)
    		if element.text:
        		text = element.text
			if element.tag == "location":
				song_location = ''.join(urllib.url2pathname(text).split("://")[1:])

				if not os.path.exists(song_location):
					print "WARNING: A song referred to from the playlist '%s' cannot be found on the harddrive." % playlist_name
					continue

				song_size = Utils.get_song_size(song_location)
				playlists[-1][1] += song_size

				songs.append( (song_location, song_size) )

	return playlists
