/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: more_teachers.c,v 1.10 2005/01/09 22:01:12 avian Exp $ */

/* 
 * AUTHOR:
 *
 *  Tomaz Solc <tomaz.solc@siol.net>
 *
 *  Ideas taken from a patch for Tablix 0.0.3 by 
 *  Jaume Obrador <obrador@espaiweb.net>
 *
 * DESCRIPTION:
 *
 *  With this module you can assign more than one teacher per lesson (tuple). 
 *  It adds a weight whenever a teacher doesn't have time (e.g. free period) to 
 *  also teach the lesson it has been assigned to with teacher-also 
 *  restriction.
 *
 *  The second teacher should have a subject with the correct title defined in 
 *  the <subjects> section of the config file.
 *
 *  Secondary teacher assignments are by default ignored by other modules (for
 *  example teacher_holes.so, etc.) and by the tablix_output utility (they 
 *  don't show up on the generated timetables). Configuring Tablix 
 *  with --enable-more-teachers fixes this, but makes Tablix a bit slower.
 *
 *  This module is actualy only a quick hack and should be fixed in the next 
 *  version.
 *
 * DEFINED TUPLE RESTRICTIONS:
 *
 *  <restriction type="teacher-also">teacher</restriction>
 *
 *  Define a secondary teacher to a tuple.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "modsup.h"
#include "data.h"
#include "gettext.h"

int **tids;
int *tidnums;

int gettid(char *type, char *cont, int tupleid)
{
	int p,c;

	c=find_teacher(cont);
	if(c<0) {
		strcpy(moderror, _("invalid teacher"));
		return(1);
	}

	p=tidnums[tupleid]++;
	tids[tupleid][p]=c;

	c=find_subject(smap[tuplemap[tupleid].sid].title, cont);
	if(c<0) {
		sprintf(moderror, _("no definition for subject '%s' for this teacher"), smap[tuplemap[tupleid].sid].title);
		return(1);
	}

	return 0;
}

parop tuple_restrictions[] = { 
	{ type : "teacher-also", parfunc: gettid },
	{ type : 0, parfunc: 0 }
};

int init_mod()
{
	int c;

	tids=malloc(sizeof(*tids)*tuplenum);
	tidnums=malloc(sizeof(*tidnums)*tuplenum);

	for(c=0;c<tuplenum;c++) {
		tids[c]=malloc(sizeof(**tids)*tmapnum);
		tidnums[c]=0;
	}
	
	return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int c,b,a,n;
	int sum;
	int *pnt;
	/* int time,ti; */

	sum=0;

        for(c=0;c<tuplenum;c++) {
                a=t->inf[c].time;

                for(pnt=start[a];pnt<lead[a];pnt++) if (*pnt!=c) {
                        b=*pnt;
			for(n=0;n<tidnums[c];n++) {
                       	        if (tuplemap[b].tid==tids[c][n]) sum++;
			}
		}
	}
/*	
        for(c=0;c<tuplenum;c++) {
		for(b=0;b<tidnums[c];b++) {
			ti=tids[c][b];
			time=t->inf[c].time;

			if(tpnt[ti*TIMES+time]!=-1) sum++;
		}
	}
*/
	return(sum);
}
