/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002-2005 Tomaz Solc                                      */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: subject_notsameday.c,v 1.2 2005/06/04 16:34:47 avian Exp $ */

/*
 * AUTHOR:
 *
 *  Antonio Duran Terres <antonio.duran.terres@gmail.com>
 *
 * DESCRIPTION:
 *
 *  Use this module if you have two subjects that you don't want
 *  scheduled in the same day.
 *
 *  Example scenario: you are using double_period.so module and need the
 *  the facilities provided by subject_sameday.so applied to all
 *  subjects in the "group".
 *
 * DEFINED CLASS RESTRICTIONS:
 *
 *  <restriction type="not-same-day">subject teacher</restriction>
 *
 *  This restriction specifies that current subject should never be taught
 *  in the same day as the subject specified in the restriction.
 *
 *  <subject title="MATH" teacher="Duran">
 *  <subject title="MATH_LAB" teacher="Duran">
 *          <restriction type="not-same-day">MATH Duran</restriction>
 *  </timetable>
 *       
 */   

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "modsup.h"
#include "data.h"
#include "gettext.h"

struct sameday {
	int sid1;
	int sid2;
};

struct sameday *samedayas;
int numsa;

int getconflict(char *type, char *cont, int sid)
{
	char title[256], teacher[256];
	int c;
	int confsid;

	c=sscanf(cont, "%s %s", title, teacher);

	if(c<1) {
		strcpy(moderror, _("invalid format of not-same-day restriction"));
		return(1);
	}

	confsid=find_subject(title, teacher);

	if (confsid==-1) {
		strcpy(moderror, _("invalid subject in not-same-day restriction"));
		return(1);
	}

	samedayas[numsa].sid1=sid;
	samedayas[numsa].sid2=confsid;

	numsa++;

	return 0;
}

parop subject_restrictions[] = { 
	{ type : "not-same-day", parfunc: getconflict },
	{ type : 0, parfunc: 0 }
};

int init_mod()
{
	samedayas=malloc(sizeof(*samedayas)*smapnum);

	if(samedayas==NULL) {
		strcpy(moderror, _("Not enough memory"));
		return 1;
	}

	numsa=0;

	return 0;
}

int is_sameday (int sid1, int sid2)
{
	int c;
	
        for(c=0;c<numsa;c++) {
		if (((samedayas[c].sid1 == sid1) && (samedayas[c].sid2 == sid2))
			|| ((samedayas[c].sid1 == sid2) && (samedayas[c].sid2 == sid1)))
			return 1;
	}
	return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int a,b,c,d;
        int flag,sid;
        int sum;
        int *pnt;
        int su[PERIODS];
        int nsu;

        sum=0;

        pnt=cpnt;

	for(c=0;c<cmapnum;c++) {
                        for (d=0;d<DAYS;d++) {
                                nsu=0;
                                for(b=0;b<PERIODS;b++) {
                                        if(*pnt!=-1) {
                                                flag=1;
                                                sid=tuplemap[*pnt].sid;

                                                for(a=0;a<nsu;a++) {

							if (is_sameday (sid, su[a])) {
								sum++;
								flag=0;
							}
                                                }
                                                if(flag) {
                                                        su[nsu]=sid;
                                                        nsu++;
                                                }
                                        }
                                        pnt++;
                                }
                        }
        }

	return(sum);
}
