/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_ERRORS_H__
#define __TPA_ERRORS_H__

#include "tpa-debug.h"

#include <glib.h>

G_BEGIN_DECLS

#define TPA_ERROR tpa_error_quark ()
/* Convenience macro to test and set a GError/return on failure */
#define g_return_error_val_if_fail(test, error, code) G_STMT_START{ \
 if G_LIKELY (test) {} else { \
   g_set_error (error, TPA_ERROR, code, tpa_error_string (code)); \
   ERROR ("%s", tpa_error_string (code)); \
   return FALSE; \
 } \
}G_STMT_END

#define g_return_context_error_val_if_fail(test, context, error, code) G_STMT_START{ \
 if G_LIKELY (test) {} else { \
   g_set_error (&error, TPA_ERROR, code, tpa_error_string (code)); \
   ERROR ("%s", tpa_error_string (code)); \
   if G_LIKELY (context) \
       dbus_g_method_return_error (context, error); \
   return FALSE; \
 } \
}G_STMT_END

typedef enum
{
    TPA_ERROR_CHANNEL_BANNED = 0,
    TPA_ERROR_CHANNEL_FULL,
    TPA_ERROR_CHANNEL_INVITE_ONLY,
    TPA_ERROR_DISCONNECTED,
    TPA_ERROR_INVALID_ARGUMENT,
    TPA_ERROR_INVALID_HANDLE,
    TPA_ERROR_NETWORK_ERROR,
    TPA_ERROR_NOT_AVAILABLE,
    TPA_ERROR_NOT_IMPLEMENTED,
    TPA_ERROR_PERMISSION_DENIED,
    TPA_ERROR_NONE,
    TPA_ERROR_LAST = TPA_ERROR_NONE
} TpaError;

GQuark      tpa_error_quark                     (void);
const gchar *tpa_error_string                   (TpaError error);

G_END_DECLS

#endif
