/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 * @author  Marcio Macedo <marcio.macedo@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CONTACT_BASE_H__
#define __TPA_CONTACT_BASE_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-avatar.h>
#include <tapioca/client/tpa-enums.h>
#include <tapioca/client/tpa-channel-target.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_CONTACT_BASE \
    (tpa_contact_base_get_type())
#define TPA_CONTACT_BASE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_CONTACT_BASE, TpaContactBase))
#define TPA_CONTACT_BASE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_CONTACT_BASE, TpaContactBaseClass))
#define TPA_IS_CONTACT_BASE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_CONTACT_BASE))
#define TPA_IS_CONTACT_BASE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_CONTACT_BASE))
#define TPA_CONTACT_BASE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_CONTACT_BASE, TpaContactBaseClass))
#define TPA_CONTACT_BASE_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_CONTACT_BASE, TpaContactBasePrivate))

typedef struct _TpaContactBase TpaContactBase;
typedef struct _TpaContactBaseClass TpaContactBaseClass;
typedef struct _TpaContactBasePrivate TpaContactBasePrivate;

struct _TpaContactBaseClass {
    TpaChannelTargetClass parent_class;
    // GType for parameter "presence" on [...].Interface.Presence.PresenceUpdate(presence) signal
    GType g_type_presence_update;
};

struct _TpaContactBase {
    TpaChannelTarget parent;
    TpaContactBasePrivate *priv;
};

GType               tpa_contact_base_get_type               (void);
const gchar *       tpa_contact_base_get_avatar_token       (TpaContactBase *self);
TpaContactPresence  tpa_contact_base_get_presence           (TpaContactBase *self);
const gchar *       tpa_contact_base_get_presence_as_string (TpaContactBase *self);
const gchar *       tpa_contact_base_get_presence_message   (TpaContactBase *self);
const gchar *       tpa_contact_base_get_alias              (TpaContactBase *self);
TpaCapability       tpa_contact_base_get_capabilities       (TpaContactBase *self);
TpaAvatar *         tpa_contact_base_get_avatar             (TpaContactBase *self);
gboolean            tpa_contact_base_request_avatar         (TpaContactBase *self);

G_END_DECLS

#endif /* #ifndef __TPA_CONTACT_BASE_H__*/
