/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CONTACT_GROUP_H__
#define __TPA_CONTACT_GROUP_H__

#include <glib.h>
#include <glib-object.h>

#include "tpa-contact.h"

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_CONTACT_GROUP \
    (tpa_contact_group_get_type())
#define TPA_CONTACT_GROUP(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_CONTACT_GROUP, TpaContactGroup))
#define TPA_CONTACT_GROUP_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_CONTACT_GROUP, TpaContactGroupClass))
#define TPA_IS_CONTACT_GROUP(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_CONTACT_GROUP))
#define TPA_IS_CONTACT_GROUP_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_CONTACT_GROUP))
#define TPA_CONTACT_GROUP_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_CONTACT_GROUP, TpaContactGroupClass))
#define TPA_CONTACT_GROUP_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_CONTACT_GROUP, TpaContactGroupPrivate))


typedef struct _TpaContactGroup TpaContactGroup;
typedef struct _TpaContactGroupClass TpaContactGroupClass;
typedef struct _TpaContactGroupPrivate TpaContactGroupPrivate;

struct _TpaContactGroupClass {
    GObjectClass parent_class;
};

struct _TpaContactGroup {
    GObject parent;
    TpaContactGroupPrivate *priv;
};

GType               tpa_contact_group_get_type          (void);
void                tpa_contact_group_invite            (TpaContactGroup *self);
gboolean            tpa_contact_group_can_invite        (TpaContactGroup *self);
void                tpa_contact_group_expel             (TpaContactGroup *self);
gboolean            tpa_contact_group_can_expel         (TpaContactGroup *self);
GPtrArray *         tpa_contact_group_get_contacts      (TpaContactGroup *self);
GPtrArray *         tpa_contact_group_get_pending_contacts
                                                        (TpaContactGroup *self);

G_END_DECLS

#endif /* #ifndef __TPA_CONTACT_GROUP_H__*/

