/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_MAIN_H__
#define __TPA_MAIN_H__

#include <glib.h>
#include <glib-object.h>

typedef struct _TpaThread TpaThread;
typedef void (* TpaCallback) (DBusGProxy *proxy, ...);

struct _TpaThread {
    TpaCallback invoke;
    DBusGProxy *proxy;
    GValueArray *args;
    gpointer data;
};

G_BEGIN_DECLS

gboolean            tpa_thread_init (gboolean thread);
void                tpa_thread_shutdown (gboolean wait);
DBusGConnection *   tpa_thread_get_bus (void);
void                tpa_thread_push (TpaThread *thread);

G_END_DECLS

#endif /* #ifndef __TPA_MAIN_H__*/
