/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_PRESENCE_PRIVATE_H__
#define __TPA_PRESENCE_PRIVATE_H__

gboolean    tpa_presence_add_status             (GObject *obj,
                                                 const gchar *status,
                                                 GHashTable *parms,
                                                 GError **error);
gboolean    tpa_presence_clear_status           (GObject *obj,
                                                 GError **error);
gboolean    tpa_presence_get_statuses           (GObject *obj,
                                                 GHashTable **ret,
                                                 GError **error);
gboolean    tpa_presence_request_presence       (GObject *obj,
                                                 const GArray *contacts,
                                                 GError **error);
gboolean    tpa_presence_remove_status          (GObject *obj,
                                                 const gchar *status,
                                                 GError **error);
gboolean    tpa_presence_set_last_activity_time (GObject *obj,
                                                 guint time,
                                                 GError **error);
gboolean    tpa_presence_set_status             (GObject *obj,
                                                 GHashTable *statuses,
                                                 GError **error);

#endif /* #ifndef __TPA_PRESENCE_PRIVATE_H__*/
