#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "concat-strings.h"

extern char *concat_strings(const char *first, ...)
{
    va_list rest;
    size_t len;
    const char *p;
    char *result;

    /* calculate length of the new string. */
    len = 0;
    va_start(rest, first);
    for (p = first; p != NULL; p = va_arg(rest, const char *)) {
        len += strlen(p);
    }
    va_end(rest);

    /* allocate enough memory. */
    result = malloc(len + 1);
    if (result == NULL) {
        return NULL;
    }
    *result = '\0';

    /* copy the arguments to the new string. */
    va_start(rest, first);
    for (p = first; p != NULL; p = va_arg(rest, const char *)) {
        strcat(result, p);
    }
    va_end(rest);

    return result;
}
