/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-page-active-conns.h:
 * A GtkNotebook page that shows all currently active Telepathy connections.
 * i.e., all D-Bus services which represents Telepathy connections.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */
 
#ifndef __TI_PAGE_ACTIVE_CONNS_H__
#define __TI_PAGE_ACTIVE_CONNS_H__

#include <gtk/gtk.h>
#include <glib-object.h>

#include "ti-page.h"

/*
 * Type macros.
 */

typedef struct _TIPageActiveConns TIPageActiveConns;
typedef struct _TIPageActiveConnsClass TIPageActiveConnsClass;

#define TI_TYPE_PAGE_ACTIVE_CONNS               ti_page_active_conns_get_type()
#define TI_PAGE_ACTIVE_CONNS(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_PAGE_ACTIVE_CONNS, TIPageActiveConns))
#define TI_PAGE_ACTIVE_CONNS_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PAGE_ACTIVE_CONNS, TIPageActiveConnsClass))
#define TI_IS_PAGE_ACTIVE_CONNS(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_PAGE_ACTIVE_CONNS))
#define TI_IS_PAGE_ACTIVE_CONNS_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PAGE_ACTIVE_CONNS))
#define TI_PAGE_ACTIVE_CONNS_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_PAGE_ACTIVE_CONNS, TIPageActiveConnsClass))

struct _TIPageActiveConns {
    TIPage parent;
};

GType ti_page_active_conns_get_type (void);

TIPageActiveConns* ti_page_active_conns_new (GtkWindow* parent_wnd, GtkNotebook* parent_notebook);

#endif
