/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-wnd-channel.h:
 * Channel Window - UI to expose org.freedesktop.Telepathy.Channel functionality
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_WND_CHANNEL_H__
#define __TI_WND_CHANNEL_H__

#include <gtk/gtk.h>
#include <glib-object.h>

#include "ti-channel.h"
#include "ti-handle-mapper.h"

/*
 * Type macros.
 */

typedef struct _TIWndChannel TIWndChannel;
typedef struct _TIWndChannelClass TIWndChannelClass;

#define TI_TYPE_WND_CHANNEL               ti_wnd_channel_get_type()
#define TI_WND_CHANNEL(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_WND_CHANNEL, TIWndChannel))
#define TI_WND_CHANNEL_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_WND_CHANNEL, TIWndChannelClass))
#define TI_IS_WND_CHANNEL(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_WND_CHANNEL))
#define TI_IS_WND_CHANNEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_WND_CHANNEL))
#define TI_WND_CHANNEL_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_WND_CHANNEL, TIWndChannelClass))

struct _TIWndChannel {
    GObject parent;
};

GType ti_wnd_channel_get_type (void);

TIWndChannel* ti_wnd_channel_new (GtkWindow* parent, TIChannel* channel, TIHandleMapper* handle_mapper);

/**
 * Show
 * Shows the channel window.
 */
void ti_wnd_channel_show (TIWndChannel* wnd_channel);

#endif
