#!/bin/sh

RGB=/usr/X11R6/lib/X11/rgb.txt

rm -f __tmp1.rgb __tmp2.rgb __tmp3.rgb

cat $RGB \
 | awk ' 
     /^!/ { ; }
     /[0-9][0-9]*/ { 
       if (NF == 4){ 
         printf("  { %-20s,\t0x%02x, 0x%02x, 0x%02x },\n",
                "\"" tolower($4) "\"", $1, $2, $3); 
       } else if (NF == 5){ 
         printf("  { %-20s,\t0x%02x, 0x%02x, 0x%02x },\n",
                "\"" tolower($4) " " tolower($5) "\"", $1, $2, $3); 
       }
     }' \
 | sed 's/ /\$/g' \
 > __tmp1.rgb
sort __tmp1.rgb \
 | sed 's/\$/ /g' \
  > __tmp2.rgb

#cat __tmp2.rgb
#exit

if [ -f rgb.h ] ; then
  cmp -s rgb.h __tmp2.rgb
  if [ $? -ne 0 ] ; then
    rm -f rgb.h
    cp __tmp2.rgb rgb.h
  fi
fi

rm -f __tmp1.rgb __tmp2.rgb __tmp3.rgb
