/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2007 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef DLTUTILS_SEEN
#define DLTUTILS_SEEN

#include <stdio.h>

#define SCREAMS(string_val)  fprintf(stderr, "\n!SCREAMS! %s:%d:%s= %s", __FILE__, __LINE__, #string_val,  string_val);  fflush(NULL)
#define SCREAMC(char_val)    fprintf(stderr, "\n!SCREAMC! %s:%d:%s= %c", __FILE__, __LINE__, #char_val,    char_val);    fflush(NULL)
#define SCREAMD(integer_val) fprintf(stderr, "\n!SCREAMD! %s:%d:%s= %d", __FILE__, __LINE__, #integer_val, integer_val); fflush(NULL)
#define SCREAMF(double_val)  fprintf(stderr, "\n!SCREAMF! %s:%d:%s= %f", __FILE__, __LINE__, #double_val,  double_val);  fflush(NULL)
#define SCREAME(double_val)  fprintf(stderr, "\n!SCREAME! %s:%d:%s= %e", __FILE__, __LINE__, #double_val,  double_val);  fflush(NULL)
#define SCREAMP(pointer_val) fprintf(stderr, "\n!SCREAMP! %s:%d:%s= %p", __FILE__, __LINE__, #pointer_val,  pointer_val);  fflush(NULL)
#define BUFFLEN          FILENAME_MAX


#if defined(__APPLE__)
    #if !defined(inline) 
        #define inline __inline__ 
    #endif 
    #include <CoreServices/CoreServices.h>
    #include <time.h>
    #include <sys/time.h>
    #include <sys/resource.h>
    #include <sys/types.h>
    #include <mach/mach_time.h>

    UInt64
    getTime(void);

    double
    seconds(void);
#endif

double
*memsetd(double *dest, const double val, size_t len);

void
myfloath(void);

void
clrscr(void);

void
write_C_mat(const double **mat, const int dim, int precision, int wrap);

char
*mystrncpy (char *s1, const char *s2, size_t n);

char
*mystrcpy (char *s1, const char *s2);

char
*mystrcat(const char *s1, const char *s2);

char
*strtolower(char *string);

char
*strtoupper(char *string);

int
printfile(FILE *infile, FILE *outfile);

void
cpfile_name(char *newname, char *oldname);

void
cpfile_fp(FILE *fnew, FILE *fold);

int
email(char *address, char program, char *datafile_name, char *histfile_name);

int
CheckForFile(char *filename);

int
GetUniqFileNameNum(const char *fname, char *newfname);

FILE
*myfopen(const char *fname, const char *mode);

int
isendline(int ch);

FILE
*linefix(char *infile_name);

char
*strtolower(char *string);

char
*strtoupper(char *string);

char
skipspace(FILE *afp);

char
skipnum(FILE *afp);

int
getfilesize(FILE *afp);

char
*slurpfile(FILE *afp);

char
*itoa(int value, char *string, int radix);

char
*getroot(char *filename);

int
program_check(char *program_system_call, FILE *stream, char *check_string);

#endif
