/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TTCONFIGFILE_H
#define TTCONFIGFILE_H

#include "LEntry.H"
#include "Contest.H"
#include <wx/wx.h>
#include <wx/config.h>
#include <vector>

/* Overview of the settings ("..." means misc. named):
 * /Settings/Bell
 *           language
 *           keybLayout
 *           toolTipDelay
 *
 * /Data/baseUrl
 *
 * /Hauptfenster/Font
 *               w
 *               h
 *               x
 *               y
 *               s
 *
 * /Kurs/.../kursnummer
 *           Fehler
 *           Richtig
 *           Zeit
 *
 * /Lektionen/Lektion.../Fehler
 *                       Richtig
 *                       Zeit
 *                       Line
 *                       Column
 *
 * /Contest/selected
 *          .../title
 *              pictureFile
 *              descrFile
 *              descrCharset
 *              lessonFile
 *              lessonCharset
 *              dataFile
 *              weight
 */

/* supported languages
 */
struct supported_langs_t {
  wxString name;
  int locale_min;
  int locale_max;
};
static struct supported_langs_t supported_langs[] = {
  {_T("english"), wxLANGUAGE_ENGLISH, wxLANGUAGE_ENGLISH_ZIMBABWE },
  {_T("german") , wxLANGUAGE_GERMAN , wxLANGUAGE_GERMAN_SWISS     },
  {_T("spanish"), wxLANGUAGE_SPANISH, wxLANGUAGE_SPANISH_VENEZUELA},
  {_T(""),0,0} //final element
};
//set on locale initialization in main.cpp
extern int current_lang;

/* a return type for the already stored courses
 * needed to hide configuration file specific knowledge
 */
class KursName {
public:
  KursName(wxString name, wxString key) : name(name),key(key) {};
  wxString name;
  wxString key;
};

/* Trying to implement this as singleton
 * This means that you can only get a pointer to it
 * by calling the static function getPtr()
 */
class TtConfigFile {
public:
  ~TtConfigFile ();
  static TtConfigFile* getPtr();

  bool getBellStatus();
  void toggleBellStatus();

  wxFont getMainWindowFont ();
  void setMainWindowFont (wxFont& storeFont);
  wxSize getMainWindowSize ();
  void setMainWindowSize (wxSize size);
  wxPoint getMainWindowPosition ();
  void setMainWindowPosition (wxPoint pos);

  int getSashPosition (int defaultPos);
  void setSashPosition (int pos);

  bool issetKeyboardLayout ();
  wxString getKeyboardLayout ();
  void setKeyboardLayout (const wxString& layout);

  bool issetLanguage ();
  wxString getLanguage ();
  void setLanguage (const wxString& lang);

  int getKursNummer (const wxString& name, const wxString& key);
  void storeKursNummer (const wxString& name, const wxString& key,
			int kursNummer);

  std::vector<LEntry>* loadKursDaten (const wxString& name,
				      const wxString& key);
  void storeKursDaten (const wxString& name, const wxString& key,
		       std::vector<LEntry>& entries);
  
  std::vector<KursName>* getKursList ();

  LEntry* loadLessonData (int index);
  void storeLessonData (int index, LEntry& entry);

  bool contestsExist();
  std::vector<ContestDesc>* getContests();
  ContestDesc getContest (long id);
  void setContest(ContestDesc& data);
  void deleteContest(long id);
  long getSelectedContestId ();
  void setSelectedContestId (long id);

  bool issetDataBaseUrl ();
  void setDataBaseUrl (const wxString& url);
  wxString getDataBaseUrl ();

  unsigned int getToolTipDelay ();
  void setToolTipDealy (unsigned int seconds);

protected:
  TtConfigFile ();

private:
  static TtConfigFile* ptr;
  wxConfigBase* pConfig;

  /* for old filename based values to be converted to an URL
   */
  wxString makeURL (const wxString& input);
};

#endif
