/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTESTSELECTDLG_H
#define CONTESTSELECTDLG_H

#include "Contest.H"
#include <wx/wx.h>
#include <vector>

class ContestSelectDlg : public wxDialog {
public:
  ContestSelectDlg (wxWindow* parent);
  ~ContestSelectDlg ();

  int ShowModal(); //redefined method from wxDialog

private:
  std::vector<ContestDesc>* l;
  wxListBox* lb;

  wxSizer* bottomButtonSizer ();
  wxSizer* selectSizer ();
  wxSizer* rightButtonSizer ();
  wxListBox* selectSizerListBox ();

  void onButtonAdd (wxCommandEvent& e);
  void onButtonDel (wxCommandEvent& e);
  void onButtonEdit (wxCommandEvent& e);
  void onButtonSelect (wxCommandEvent& e);
  void onListBoxSelect (wxCommandEvent& e);
  DECLARE_EVENT_TABLE()
};

#endif

