/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <wx/wx.h>
#include "dirs.H"
#include "UrlSelectPanel.H"

#ifndef FILEURLSELECTDLG_H
#define FILEURLSELECTDLG_H

class UrlSelectDlg : public wxDialog {
public:
  UrlSelectDlg (wxWindow* parent, int id,
		bool can_be_empty = false);

  wxString getURLstr ();

protected:
  void init (UrlSelectPanel* urlPanel);
  UrlSelectPanel* urlPanel;

private:
  bool can_be_empty;

  wxSizer* getButtonSizer (wxWindow* parent);
  void onButtonOK (wxCommandEvent& e);

  DECLARE_EVENT_TABLE()
};

class FileUrlSelectDlg : public UrlSelectDlg {
public:
  virtual UrlFile* getURL ();

protected:
  FileUrlSelectDlg (wxWindow* parent, int id,
		    bool can_be_empty = false)
    : UrlSelectDlg (parent,id,can_be_empty) {}

private:
  //this gets never called but prevents this class
  //from being instantiated
  FileUrlSelectDlg () : UrlSelectDlg(0,-1) {};
};

class BinaryFileUrlSelectDlg : public FileUrlSelectDlg {
public:
  BinaryFileUrlSelectDlg (wxWindow* parent, int id,
			  UrlFile defaultUrl = UrlFile(),
			  bool can_be_empty = false);
};

class TextFileUrlSelectDlg : public FileUrlSelectDlg {
public:
  TextFileUrlSelectDlg (wxWindow* parent, int id,
			UrlFile defaultUrl = UrlFile(),
			bool can_be_empty = false);

  UrlFile* getURL ();
  wxString getCharset ();
};

#endif
