/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LKRIT_H
#define LKRIT_H

#include <wx/wx.h>
#include <wx/datetime.h>

/* Die Klasse LKrit enthlt die Kriterien fr die einzelnen
 * Lektionen
 */
class LKrit {
 public:
  LKrit(int nummer, int zeit, int promille);
  ~LKrit() {};

  void setNummer(int nummer) { this->nummer = nummer; };
  int getNummer() const { return this->nummer; };

  void setZeit(time_t zeit) { this->zeit = zeit; };
  time_t getZeit() const { return this->zeit; };
  wxString getZeitString() const { return wxDateTime(getZeit()).Format(_T("%X"),wxDateTime::TimeZone(wxDateTime::UTC)); };

  void setPromille(int promille) { this->promille = promille; };
  int getPromille() const { return this->promille; };

 private:
  int nummer;
  time_t zeit;
  int promille;
};

#endif
