/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LEKTIONSAUSWAHL_H
#define LEKTIONSAUSWAHL_H

#include "kurs.h"
#include "LessonStatusSizer.H"
#include <wx/wx.h>
#include <wx/textctrl.h>
#include <wx/notebook.h>

/* Klasse fr den Lektionsauswahldialog
 */
class Lektionsauswahl : public wxDialog {
 public:
  Lektionsauswahl(wxWindow* parent);
  ~Lektionsauswahl();
  // Event Handler
  void OnLektionStarten(wxCommandEvent& event);
  void OnListBox(wxCommandEvent& event);
  // andere Funktionen
  inline int GetLektion() { return lb->GetSelection() + 1; };

 private:
  wxButton* btnOk;
  wxButton* btnCancel;
  wxArrayString ar;
  wxListBox* lb;
  wxStaticBox* sb;
  wxStaticBoxSizer* sbSizer; //don't delete in destructor!
  wxStaticText* st;
  LessonStatusSizer* lss; //don't delete in destructor!

  wxNotebook *notebook;

  wxPanel* getIncludedLessonPage (wxWindow* parent);
  wxListBox* getIncludedLessonListBox (wxWindow* parent, int id);

  wxPanel* getAddonLessonPage (wxWindow* parent);
  wxListBox* getAddonLessonPageListBox (wxWindow* parent);

  int lastselection;

  DECLARE_EVENT_TABLE()
};

#endif
