# $id$

#
# if you're running tkabber under the tkcon package 
#
#     http://tkcon.sourceforge.net
#
# e.g.,
#
#     % tkcon.tcl -name tkabber -exec "" -root .tkconn -main "source tkabber.tcl"
#
# or if tkcon is installed as a Tcl package and can be sourced via
# [package require] (tkcon isn't loaded at start, so it doesn't waste resources
# if it's unneeded)
#

if {[lempty [package versions tkcon]] && \
	[llength [info commands ::tkcon::*]] <= 0} {
    return
}

namespace eval tkcon {
    variable showP 0
}

proc tkcon::add_tkcon_to_tkabber_menu {args} {
    catch {
	set ndx [.menubar index [::msgcat::mc "Help"]]
	set menu [.menubar entrycget $ndx -menu]
	$menu add separator
	$menu add checkbutton -label [::msgcat::mc "Show TkCon console"] \
	      -command  [namespace current]::show_console \
	      -variable [namespace current]::showP
	show_console
    }
}

proc tkcon::show_console {} {
    variable showP

    if {[llength [info commands ::tkcon::*]] <= 0} {
	package require tkcon
    }

    if {$showP} {
	tkcon show
    } else {
	tkcon hide
    }
}

hook::add finload_hook [namespace current]::tkcon::add_tkcon_to_tkabber_menu

