## This plugin implements a printfilter
## selector for tkchooser
##
## Ethan Gold <etgold@cs.vassar.edu> 3/27/98

if {[debug]} { puts "loading Printfilter plugin.." }

## register the plugin with the main chooser
register_plugin misc printfilter PrintFilter

#### required functions to return plugin information
#### use these instead of globals
proc printfilter.geticon {} { return "printfilter.pnm" }
proc printfilter.getpubname {} { return "Printfilter" }
proc printfilter.getprotocol {} { return "misc" }

####### required functions that actually do stuff (maybe) #########

## start function
proc printfilter.start {} {
    ## read in config file and set options as global
    if {[debug]} {puts "printfilter: starting printfilter plugin"}
    printfilter.widgets "start"
    printfilter.readfilts
    printfilter.selectcurrent
}

## stop function
proc printfilter.stop {} {
    ## global data area will automatically be cleared
    if {[debug]} {puts "printfilter: stopping printfilter plugin"}
    printfilter.widgets "stop"
}

## doubleclick callback
proc printfilter.doubleclick {} {
    ## get the value of the double-clicked item
    ## and pass it to the configurator
    printfilter.configfilt [get_curr_item]
}

## callback for new zone selection
proc printfilter.newzone {} {
    ## do nothing
}

####### end required functions ########

proc printfilter.readfilts {} {
    global userconfdir libdir
    set pluglist [plug_list]
    set plugframe [plug_frame]
    $plugframe.status configure -text "reading filters..."
    update

    printfilter.clearfilts

    set filters ""
    
    ## read global printfilters
    set fd [open "|/bin/ls $libdir/etc/" r]
    while {[gets $fd line] != -1} {
	foreach name $line {
	    if {[regexp {^printfilter\..+} $name]} {
		set name [lindex [split $name .] 1]
		set filters "$filters public:$name"
		if {[debug]} {puts "printfilter: found $name"}
	    }
	}
    }
    close $fd

    ## read personal printfilters
    set fd [open "|/bin/ls $userconfdir" r]
    while {[gets $fd line] != -1} {
	foreach name $line {
	    if {[regexp {^printfilter\..+} $name]} {
		set name [lindex [split $name .] 1]
		set filters "$filters private:$name"
		if {[debug]} {puts "printfilter: found $name"}
	    }
	}
    }
    close $fd

    set filters [lsort -dictionary $filters]
    foreach filter $filters {
	$pluglist insert end $filter
    }
    set_glob filters $filters

    $plugframe.status configure -text "ready."
    update
}

## procedure to build and destroy main
## plugin frame widgets
proc printfilter.widgets {command} {
    global userconfdir
    set plugframe [plug_frame]
    
    if {[string compare $command "start"] == 0} {
	
	button $plugframe.use -text "use" -width 10\
		-command "printfilter.use"
	button $plugframe.new -text "new..." -width 10\
		-command "printfilter.configfilt $userconfdir/printfilter.New"
	button $plugframe.delete -text "delete" -width 10 \
		-command "printfilter.delfilter"
	pack $plugframe.use
	pack $plugframe.new
	pack $plugframe.delete
    } else {
	destroy $plugframe.use
	destroy $plugframe.new
	destroy $plugframe.delete
    }

}

proc printfilter.use {} {
    global libdir userconfdir
    set filter [get_curr_item]

    ## set the filename for the filter
    set type [lindex [split $filter :] 0]
    set filtname [lindex [split $filter :] 1]

    if {[string compare $type "public"] == 0} {
	set filtfile "$libdir/etc/printfilter.$filtname"
    } else {
	set filtfile "$userconfdir/printfilter.$filtname"
    }
    
    catch {file delete -force "$userconfdir/printfilter"}
    exec ln -s $filtfile $userconfdir/printfilter

    #if {[string compare $filtfile "$userconfdir/printfilter.$filtname"] != 0} {
	#catch {file delete "$userconfdir/printfilter.$filtname"}
	#file copy $filtfile "$userconfdir/printfilter.$filtname"
    #}

    printfilter.readfilts
    printfilter.selectcurrent
}

## procedure to build a window to edit the
## name and commandline for the filter
proc printfilter.configfilt {filter} {
    global libdir userconfdir
    global pf_cmdline pf_filtname

    set pf_cmdline ""
    set pf_filtname ""

    ## read in the filter line from the file
    set type [lindex [split $filter :] 0]
    set pf_filtname [lindex [split $filter :] 1]

    if {[string compare $type "public"] == 0} {
	set filtfile "$libdir/etc/printfilter.$pf_filtname"
    } else {
	set filtfile "$userconfdir/printfilter.$pf_filtname"
    }
    
    if {[file readable $filtfile]} {
    
	set fd [open $filtfile r]
	gets $fd pf_cmdline
	if {[debug]} {puts "printfilter: cmdline for $pf_filtname is \"$pf_cmdline\""}
	close $fd
    }

    set w .config
    catch {destroy $w}
    toplevel $w -class Dialog
    
    label $w.namelabel -text "Name:"
    entry $w.nameentry -textvariable pf_filtname \
	    -width 40 -exportselection 0
    label $w.cmdlabel -text "Commandline - Must output to stdout"
    entry $w.cmdentry -textvariable pf_cmdline \
	    -width 40 -exportselection 0
    button $w.cancel -text "Cancel" -command "destroy $w"
    button $w.ok -text "Ok" \
	    -command "printfilter.newfilt \$pf_filtname \
	    \"\$pf_cmdline\"; destroy $w" \
	    -default active

    pack $w.namelabel
    pack $w.nameentry
    pack $w.cmdlabel
    pack $w.cmdentry
    pack $w.cancel -side left -anchor s -padx 2 -pady 2
    pack $w.ok -side right -anchor s

    wm title $w "Configure $filter"

    update
}

proc printfilter.newfilt {newname newcmd} {
    ## if the file exists, overwrite it.
    ## if not, make a new one.
    global libdir userconfdir
    set fd [open "$userconfdir/printfilter.$newname" w]
    
    puts $fd $newcmd
    close $fd
    printfilter.readfilts
    printfilter.selectcurrent
}

proc printfilter.delfilter {} {
    global userconfdir
    set filter [get_curr_item]
    
    if {[debug]} {puts "enscript: delfilter: curritem is $filter"}

    set type [lindex [split $filter :] 0]
    set filter [lindex [split $filter :] 1]

    if {[debug]} {puts "enscript: delfilter: type is $type"}
    if {[debug]} {puts "enscript: delfilter: filter is $filter"}

    if {[string compare $type "public"] == 0} {
	error "Printfilter" "You can't delete the public filters."
    } else {
	catch {file delete -force "$userconfdir/printfilter.$filter"}
	set currfiltfile [file readlink $userconfdir/printfilter]
	if {[debug]} {puts "enscript: delfilter: currfilter is $currfiltfile"}
	if {[string compare $currfiltfile $userconfdir/printfilter.$filter] \
		== 0} {
	    catch {file delete $userconfdir/printfilter}
	}
	printfilter.readfilts
	printfilter.selectcurrent
    }

    printfilter.selectcurrent
    ## if we deleted the filter in use, remove the link.
}

## procedure to select the current filter
proc printfilter.selectcurrent {} {
    global userconfdir libdir
    if {![file readable $userconfdir/printfilter]} { return }

    set filtfile [file readlink $userconfdir/printfilter]
    set filtname [file tail $filtfile]
    set filtname [lrange [split $filtname \.] 1 end]
    set dirname [file dirname $filtfile]
    if {[string compare $dirname "$libdir/etc"] == 0} {
	set filtname "public:$filtname"
    } else {
	set filtname "private:$filtname"
    }

    if {[debug]} {puts "enscript: filterfile: $filtfile"}
    if {[debug]} {puts "enscript: filtername: $filtname"}
    set pluglist [plug_list]
    set size [$pluglist size]

    for {set i 0} {$i<$size} {incr i} {
	set name [$pluglist get $i]
	if {[string compare $name $filtname] == 0} {
	    $pluglist selection set $i
	    ## make sure the curr selection variable gets set
	    event generate $pluglist <ButtonRelease>
	    update
	    return
	}
    }

}

proc printfilter.clearfilts {} {
    set pluglist [plug_list]
    $pluglist delete 0 end
}

#########
if {[debug]} {puts "Finished loading printfilter plugin."}


