## This is the plugin to handle smb laserwriters under
## tkchooser2. It has no access to global variables, only
## procedures and functions
##
## Ethan Gold <etgold@cs.vassar.edu> 2/24/98
##

## must provide a name, public name, and icon in addition to
## start and stop procedures

## these don't work as globals, only for
## non-procedural initialization

if {[debug]} { puts "loading smbprint..." }

## register the plugin with the main chooser
register_plugin smb smbprint Printers

########## required functions #################

#### required procedures that simply return plugin information
proc smbprint.geticon {} { return "smbprint.pnm" }
proc smbprint.getpubname {} { return "Printers" }
proc smbprint.getprotocol {} { return "smb" }
proc smbprint.afterdelay {} { return "120000" }

## start function - required
proc smbprint.start {} {
    if {[debug]} { puts "started Printers Plugin" }

    set entlabel [plug_list_label]
    $entlabel configure -text "Print Hosts:"
    update
    smbprint.widgets stop
    smbprint.widgets start
    smbprint.refresh
}

## stop funtion - required
proc smbprint.stop {} {
    if {[debug]} { puts "stopped Printers Plugin" }
    smb.delmachines
    set ID [get_glob afterID]
    if {[string compare $ID ""] != 0 } {
	after cancel $ID
    }
    smbprint.widgets stop
}

## function to call when a listitem is double-clicked
proc smbprint.doubleclick {} {
    if {[debug]} { puts "smbprint: got double-click with [get_curr_item]" }
    set plugframe [plug_frame]
    $plugframe.print invoke
}

proc smbprint.newzone {} {
    smb.setmachines
    #set plugframe [plug_frame]
    #$plugframe.status configure -text "scanning [smb.getcurrzone]..."
    #update
    #smbprint.clearentities
    #smbprint.showentities [smbprint.getnames]
    #$plugframe.status configure -text "ready."
}

############# End required functions ##################

proc smbprint.refresh {} {
    smbprint.newzone
    set_glob afterID [ after [smbprint.afterdelay] {smbprint.refresh}]
}

## procedure to actually invoke the printing commands
proc smbprint.printfile {guestflag filterflag username password machine} {
    global printfilterfile

    set printer [get_glob printer]
    set filename [get_glob file]

    ## make sure the needed parameters are set
    if {[string compare $printer ""] == 0} {return}
    if {[string compare $filename ""] == 0} {return}
    
    if {[string compare $username ""] == 0} {
	set name "-N"
    } else { set name "-U $username\%$password" }
    if {$guestflag} { set name "-N" }


    if {[debug]} {
	regsub -all {.} $password "\*" fakepass
	puts "smbprint: printfile called with $guestflag, \
		$filterflag, $username, $fakepass, $filename, $printer"
    }

    if {!$filterflag} {
	#puts "smbprint: executing cat $filename | smbclient '\\\\$machine\\$printer' $name -P -c \"print -\""
	catch {exec cat $filename | smbclient \\\\$machine\\$printer $name -P -c "print -"} result

	puts "smbprint: result was: $result"
	
    } else {
	if {[file readable $printfilterfile]} {
	    ## read in filter command
	    set filtfd [open "$printfilterfile" r]
	    gets $filtfd filtcmd
	    close $filtfd
	    puts "smprint: executing "
	    set printername "\\\\\\\\$machine\\\\$printer"
	    catch {eval exec $filtcmd $filename | smbclient $printername $name -P -c \"print -\"} result
	    puts "smbprint: result was $result"
	    
	} else {
	    error "sbmprint" "Could not find the printfilter file \
		    $printfilterfile. Please uncheck the filter \
		    option and try again."
	    return ""
	}
    }

}

## procedure to preview a file to be printed
proc smbprint.previewfile {filterflag} {
    global printpreviewer printfilterfile
    if {[string compare $printpreviewer "" ] == 0 || !$filterflag} {
	set printpreviewer "xterm -e more"
    }
    set thefile [get_glob "file"]
    if {[string compare $thefile ""] == 0} {
	puts "smbprint: no file specified"
	return
    }
    set filename [tilde $thefile]
    if {$filterflag} {
	if {[file readable $printfilterfile]} {
	    ## read in filter command
	    set filtfd [open "$printfilterfile" r]
	    gets $filtfd filtcmd
	    close $filtfd
	    if {[debug]} {
		puts "smbprint: opening |$filtcmd $filename | $printpreviewer"
	    }
	    set result ""
	    catch {eval exec $filtcmd $filename | $printpreviewer} result
	    if {[debug]} {puts "smbprint: $result"}
	} else {
	    error "Printers" "Could not find the printfilter file \
		    $printfilterfile. Please uncheck the filter \
		    option and try again."
	    return
	}
    } else {
	catch {eval exec $printpreviewer $filename } result
    }
}


## procedure to get a filename, set it globally, and list
## it in the filename widget
proc smbprint.getfilename {filename} {    
    set_glob file "[pwd]/$filename"
    .smbprintwin.fframe.file configure -text [get_glob "file"]
    if {[debug]} { puts "smbprint: file was [get_glob file]" }
}

## procedure to call smb print function
proc smbprint.printwin {guestflag username password machine} {
    if {[debug]} {
	puts "smbprint: printwin called with $guestflag, \
		$username, $password, $machine"
    }
    
    set filterflag 0
    set_glob printer ""
    set_glob file ""

    ## build the window
    set w .smbprintwin
    destroy $w
    toplevel $w -class Dialog
    frame $w.lframe
    frame $w.fframe
    label $w.label -text "Printers on $machine: " -relief groove
    checkbutton $w.filter -text "Use Filter" -variable filterflag
    listbox $w.lframe.printers -yscrollcommand "$w.lframe.scroll set" \
	    -height 6 -width 30 -exportselection 0
    scrollbar $w.lframe.scroll -command "$w.lframe.printers yview"
    message $w.fframe.file -width 200 -relief sunken \
	    -text ""
    label $w.fframe.label -text "File: "
    button $w.print -text "Print" -command \
	    "smbprint.printfile \$guestflag \$filterflag \"$username\" \"$password\" \"$machine\""
    button $w.preview -text "Preview" -command "smbprint.previewfile \$filterflag"
    button $w.cancel -text "Close" -command "destroy $w"
   
    pack $w.lframe.printers -side left
    pack $w.lframe.scroll -side right -fill y
    pack $w.fframe.label -side left
    pack $w.fframe.file -side right

    pack $w.label -fill x
    pack $w.lframe
    pack $w.fframe
    pack $w.filter
    pack $w.cancel -side left -anchor s -padx 10 -pady 10
    pack $w.print -side right -anchor s -padx 10 -pady 10
    pack $w.preview -side right -padx 10 -pady 10

    bind $w.fframe.file <ButtonRelease> {
	fileselect smbprint.getfilename
    }
    
    bind $w.lframe.printers <ButtonRelease> \
	    "set_glob printer \[$w.lframe.printers get \[$w.lframe.printers curselection\]\]"

    
    ## fill the listbox with names
    set services [smb.getservices $machine Printer $guestflag $username $password]
    foreach name $services {
	$w.lframe.printers insert end $name
    }
    if {[debug]} {puts "smb: got services: $services"}
}

## function to build window to login to machines
proc smbprint.mountwindow {server} {
    
    set username ""
    set password ""
    ## make sure something's selected
    if {[string compare $server ""] == 0} {
	return
    }

    set w ".smbprint_mountwin"
    set smbprintguestflag 0

    ## we are only going to support one mount window
    ## at a time for now. this is easily changed.
    destroy $w
    
    ## build mounting window
    toplevel $w -class Dialog
    label $w.label -text \
	    " \nConnect to the file server \"$server\" as: \n" \
	    -font [get_propfont]

    checkbutton $w.guest -variable smbprintguestflag \
	    -text "Guest" -font [get_propfont] \
	    -command "toggleentries $w smbprintguestflag"

    label $w.spacelabel1 -text "\n"
    label $w.spacelabel2 -text "\n"
    frame $w.nameframe
    frame $w.passframe
    label $w.nameframe.namelabel -text "Name:     " -font [get_fixedfont]
    label $w.passframe.passlabel -text "Password: " -font [get_fixedfont]
    entry $w.nameframe.name -textvariable username -exportselection 0
    entry $w.passframe.pass -textvariable password -exportselection 0 -show "*"
    pack $w.nameframe.namelabel -side left -anchor n
    pack $w.nameframe.name -side right -anchor n
    pack $w.passframe.passlabel -side left -anchor n
    pack $w.passframe.pass -side right -anchor n
    button $w.cancel -text "Cancel" \
	    -command "destroy $w"
    button $w.ok -text "OK" \
	    -command "destroy $w; smbprint.printwin \"\$smbprintguestflag\" \"\$username\" \"\$password\" \"$server\"" -default active

    pack $w.label -side top -padx 5
    pack $w.guest -side top -anchor w -padx 15
    pack $w.spacelabel1 -side top
    pack $w.nameframe -side top -anchor w  -padx 15
    pack $w.passframe -side top -anchor w  -padx 15
    #pack $w.spacelabel2 -side top
    pack $w.cancel -side left -anchor s -padx 10 -pady 10
    pack $w.ok -side right -anchor s -padx 10 -pady 10
    update
    focus $w.nameframe.name

    bind $w.passframe.pass <Return> "$w.ok invoke"
    bind $w <Control-c> "$w.cancel invoke"
    bind $w.cancel <Return> "$w.cancel invoke"
    bind $w.ok <Return> "$w.ok invoke"
}


## procedure to build and destroy smbprint widgets
proc smbprint.widgets {command} {
    set plugframe [plug_frame]

    if {[string compare $command "start"] == 0} {

	button $plugframe.print -text "Print File..." \
		-command {smbprint.mountwindow [get_curr_item]}
	#-command "smbprint.mountwindow \"\[get_curr_item\]\""
	
	pack $plugframe.print
	$plugframe.status configure -text "ready."

    } else {
	destroy $plugframe.print
    }
    
}

## function to return the Printerss in the current zone
proc smbprint.getnames {} {
    return [smb.namesfromlkup [smbprint.getentities]]
}

proc smbprint.getentities {} {
    set currzone [smb.getcurrzone]
    set entity ""
    set results [smb.nbplkup $entity]
    set results [smb.namesfromlkup $results]
    return $results
}

## function to display passed in entities in
## the plugin's entity list frame
proc smbprint.showentities {entitylist} {
    set lbox [plug_list]
    foreach entity $entitylist {
	$lbox insert end $entity
    }
}

proc smbprint.clearentities {} {
    set lbox [plug_list]
    $lbox delete 0 end
}

if {[debug]} { puts "finished loading smbprint." }
