#include <main.h>
#include <docklet.h>
#include <utils.h>
#include <support.h>
#include <lista.h>

guint notify_items_num = 0;


guint _notify_events_pending_count()
{
	GList *ulist = users_list;
	struct user *user = NULL;
	guint l = 0;

	while(ulist) {
		user = (struct user*)ulist->data;
		if( (user) && (user->pending_event) ) 
			l++;
		ulist = ulist->next;
		user = NULL;
	}
	
	return l;
}


/* Show number of pending notify events on label below roster */
void _notify_events_num_show()
{
	GtkWidget *widget = NULL;
	gchar *s = NULL, *s1 = NULL;
	
	widget = lookup_widget(window1,"label_info");
	if(notify_items_num) {
		s1 = g_strdup_printf("Nowe wiadomoci: %d", notify_items_num);
		s = utf(s1);
		gtk_label_set_text(GTK_LABEL(widget), s);
		gtk_widget_show(widget);
		g_free(s1);
		g_free(s);
	}
	else
		gtk_widget_hide(widget);
	
}


/* Assign notify event to specified user */
void notify_start(guint type, gchar *jid)
{
	struct user *user = get_user(jid);
	
	notify_items_num++;
	_notify_events_num_show();
	
	if(user) 
		user->pending_event = type;

#ifndef DISABLE_DOCKLET
	docklet_notify_start(type);
#endif

}


/* Clear notify event(s) for specified user */
void notify_clear(gchar *jid)
{
	struct user *user = get_user(jid);

	if(user)
		user->pending_event = NOTIFY_NOEVENT;

	list_refresh();
	
	notify_items_num = _notify_events_pending_count();
	tleenx_print(DEBUG, "items num: %d\n", notify_items_num);
	_notify_events_num_show();
	
#ifndef DISABLE_DOCKLET
	if(!notify_items_num)
		docklet_notify_clear();
#endif

}


