/***************************************************************************
*   Copyright (C) 2006 by Robert Hogan                                    *
*   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.            *
 ***************************************************************************/

#include "torkconfig.h"
#include <klocale.h>
#include <qtooltip.h>
#include <qpopupmenu.h>
#include <kdebug.h>

void FirewallsProxies::init()
{

    QStringList existingMaps = TorkConfig::reachableAddresses();
    QListViewItem *tm;
	for ( QStringList::Iterator it = existingMaps.begin(); it != existingMaps.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        QString entry = (*it).section(":",0,0);
        QString port = (*it).section(":",1,1);

        tm = new QListViewItem(ReachableAddresses,port);
    }

    existingMaps = TorkConfig::bridge();
	for ( QStringList::Iterator it = existingMaps.begin(); it != existingMaps.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        QString entry = (*it).section(":",0,0);
        QString port = (*it).section(" ",0,0).section(":",1,1);
        QString key = (*it).section(" ",1);

        tm = new QListViewItem(Bridge,entry,port,key);
    }

}
void FirewallsProxies::pushAdd_clicked()
{
    new QListViewItem(ReachableAddresses,Port->text());

}



void FirewallsProxies::ReachableAddresses_contextMenuRequested( QListViewItem *, const QPoint &point, int )
{

    QPopupMenu *menu = new QPopupMenu( ReachableAddresses );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteEntry()) );
    menu->popup( point );

}


void FirewallsProxies::slotDeleteEntry( )
{

    QListViewItemIterator it(ReachableAddresses, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (ReachableAddresses->isSelected( it.current()))
            delete it.current();
        ++it;
    }

}


// <connections>
//     <connection>
//         <sender>pushAdd</sender>
//         <signal>clicked()</signal>
//         <receiver>FirewallsProxies</receiver>
//         <slot>pushAdd_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>ReachableAddresses</sender>
//         <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
//         <receiver>FirewallsProxies</receiver>
//         <slot>ReachableAddresses_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
//     </connection>
// </connections>
// <includes>
//     <include location="local" impldecl="in implementation">firewallsproxies.ui.h</include>
// </includes>
// <slots>
//     <slot>pushAdd_clicked()</slot>
//     <slot>ReachableAddresses_contextMenuRequested( QListViewItem *, const QPoint &amp; point, int )</slot>
//     <slot>slotDeleteEntry()</slot>
// </slots>
// <functions>
//     <function access="private" specifier="non virtual">init()</function>
// </functions>
// <layoutdefaults spacing="6" margin="11"/>
// </UI>


void FirewallsProxies::kcfg_FascistFirewall_toggled( bool on )
{
    Firewall->setEnabled(on);
}

void FirewallsProxies::kcfg_UseProxy_toggled( bool on)
{
    Proxies->setEnabled(on);
}

void FirewallsProxies::kcfg_HttpProxyHost_textChanged( const QString & text)
{
    kcfg_HttpsProxyHost->setText(text);
}


void FirewallsProxies::kcfg_HttpProxyPort_valueChanged( int text)
{
    kcfg_HttpsProxyPort->setValue(text);
}


void FirewallsProxies::kcfg_HttpProxyAuthenticatorUserName_textChanged( const QString & text)
{
    kcfg_HttpsProxyAuthenticatorUserName->setText(text);
}


void FirewallsProxies::kcfg_HttpProxyAuthenticatorPassword_textChanged( const QString & text)
{
    kcfg_HttpsProxyAuthenticatorPassword->setText(text);
}




void FirewallsProxies::pushBridgeAdd_clicked()
{
    new QListViewItem(Bridge,BridgeAddress->text(),BridgePort->text(),BridgeKey->text());

}


void FirewallsProxies::kcfg_UseBridges_toggled( bool on)
{
    BridgePanel->setEnabled(on);
}


void FirewallsProxies::Bridge_contextMenuRequested( QListViewItem *, const QPoint & point, int )
{
    QPopupMenu *menu = new QPopupMenu( Bridge );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteBridgesEntry()) );
    menu->popup( point );

}

void FirewallsProxies::slotDeleteBridgesEntry( )
{

    QListViewItemIterator it(Bridge, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (Bridge->isSelected( it.current()))
            delete it.current();
        ++it;
    }

}
