/*
 * Copyright (C) 2007 Marylene Ysmal <wiidevel@stacktic.org>
 *
 * pageAbout.c (TransferMii)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */ 

#include "pageAbout.h"

GtkWidget* createPageAbout(void){
	GtkWidget *mainVBox;

	GtkWidget *frame;
	GtkWidget *label;
	
	GtkWidget *textView;
	GtkWidget *scrolledWindow;
	GtkWidget *authorsVBox;

	GtkTextBuffer *buffer;
	GtkTextIter iter;

	
	/* Main vbox initialisation */
	mainVBox=gtk_vbox_new(FALSE, 0);
	
	/* Authors frame */
	frame=gtk_frame_new("Authors");
    	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
    	
	authorsVBox=gtk_vbox_new(FALSE, 5);
    	gtk_container_set_border_width(GTK_CONTAINER(authorsVBox), 10);
	
	label=gtk_label_new("Main Program : Arnaud Ysmal");
	gtk_box_pack_start(GTK_BOX(authorsVBox), label, FALSE, TRUE, 0);
	label=gtk_label_new("GUI : Marylene Ysmal");
	gtk_box_pack_start(GTK_BOX(authorsVBox), label, FALSE, TRUE, 0);
	label=gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(authorsVBox), label, FALSE, TRUE, 0);
	label=gtk_label_new("Contact : wiidevel@stacktic.org");
	gtk_box_pack_start(GTK_BOX(authorsVBox), label, FALSE, TRUE, 0);
		
	gtk_container_add(GTK_CONTAINER(frame), authorsVBox); 
	
	gtk_box_pack_start(GTK_BOX(mainVBox), frame, FALSE, TRUE, 0);


	/* License frame */
	frame=gtk_frame_new("License");
    	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);

	/* Scrolled Window */
	scrolledWindow=gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledWindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	/* TextView */
	textView=gtk_text_view_new();
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textView),GTK_WRAP_WORD);
	gtk_container_set_border_width(GTK_CONTAINER(textView), 10);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(textView),FALSE);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(textView),FALSE);
	
	/* Filling the TextView */
	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(textView));
	gtk_text_buffer_set_text(buffer, "", 0);
	gtk_text_buffer_get_iter_at_offset(buffer, &iter, 0);
	gtk_text_buffer_insert(buffer, &iter, TMII_LICENSE, -1);

	gtk_container_add(GTK_CONTAINER(scrolledWindow), textView);
	gtk_container_add(GTK_CONTAINER(frame), scrolledWindow);

	gtk_box_pack_start(GTK_BOX(mainVBox), frame, TRUE, TRUE, 0);
	
	return mainVBox;
}
