//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#if (QT_REL == 3)

#include <iostream>

#include <qstringlist.h>
#include <qwidgetplugin.h>

#include "tulip/Graph.h"
#include "tulip/PropertyWidget.h"
#include "tulip/GlGraphWidget.h"
#include "tulip/GWOverviewWidget.h"
#include "tulip/ElementPropertiesWidget.h"
#include "tulip/SGHierarchyWidget.h"

#include "../designer/sghierarchywidget.xpm"
#include "../designer/gwoverviewwidget.xpm"
#include "../designer/elementtable.xpm"
#include "../designer/GlGraphWidget.xpm"


using namespace std;
using namespace tlp;

class QT_WIDGET_PLUGIN_EXPORT TulipWidgetsPlugin : public QWidgetPlugin
{
public:
  TulipWidgetsPlugin();
  ~TulipWidgetsPlugin();
  
  QStringList keys() const;
  QWidget* create( const QString &classname, QWidget* parent = 0, const char* name = 0 );
  QString group( const QString& ) const;
  QIconSet iconSet( const QString& ) const;
  QString includeFile( const QString& ) const;
  QString toolTip( const QString& ) const;
  QString whatsThis( const QString& ) const;
  bool isContainer( const QString& ) const;
};

TulipWidgetsPlugin::TulipWidgetsPlugin() {}
TulipWidgetsPlugin::~TulipWidgetsPlugin() {}

QStringList TulipWidgetsPlugin::keys() const {
  QStringList list;
  list << "PropertyWidget";
  list << "ElementPropertiesWidget";
  list << "GlGraphWidget";
  list << "GWOverviewWidget";
  list << "SGHierarchyWidget";
  return list;
}

QWidget* TulipWidgetsPlugin::create(const QString &key, QWidget* parent, const char* name) {
  if (key == "PropertyWidget") return new PropertyWidget(parent, name);
  if (key == "ElementPropertiesWidget") return new ElementPropertiesWidget(NULL, QStringList(), QStringList(), parent, name);
  if (key == "GlGraphWidget") return new GlGraphWidget(parent, name);
  if (key == "GWOverviewWidget") return new GWOverviewWidget(parent, name);
  if (key == "SGHierarchyWidget") return new SGHierarchyWidget(/* graph, */ parent, name);
  return 0;
}

QString TulipWidgetsPlugin::includeFile(const QString& feature) const {
  if (feature == "PropertyWidget") return "tulip/PropertyWidget.h";
  if (feature == "ElementPropertiesWidget") return "tulip/ElementPropertiesWidget.h";
  if (feature == "GlGraphWidget") return "tulip/GlGraphWidget.h";
  if (feature == "GWOverviewWidget") return "tulip/GWOverviewWidget.h";
  if (feature == "SGHierarchyWidget") return "tulip/SGHierarchyWidget.h";
  return QString::null;
}

QString TulipWidgetsPlugin::group(const QString& feature) const {
  if ((feature == "PropertyWidget")
      || (feature == "GlGraphWidget")
      || (feature == "GWOverviewWidget")
      || (feature == "ElementPropertiesWidget")
      || (feature == "SGHierarchyWidget"))
    return "Tulip";
  return QString::null;
}

QIconSet TulipWidgetsPlugin::iconSet(const QString& feature) const {
  if (feature == "PropertyWidget") return QIconSet(QPixmap(elementtable_xpm));
  if (feature == "GlGraphWidget") return QIconSet(QPixmap(GlGraphWidget_xpm));
  if (feature == "GWOverviewWidget") return QIconSet(QPixmap(gwoverviewwidget_xpm));
  if (feature == "ElementPropertiesWidget") return QIconSet(QPixmap(elementtable_xpm));
  if (feature == "SGHierarchyWidget") return QIconSet(QPixmap(sghierarchywidget_xpm));
  return QIconSet();
}

QString TulipWidgetsPlugin::toolTip(const QString& feature) const {
  if (feature == "PropertyWidget") return tr("Graph Properties Widget");
  if (feature == "ElementPropertiesWidget") return tr("Node/Edge Properties Widget");
  if (feature == "GlGraphWidget") return tr("GlGraph Widget");
  if (feature == "GWOverviewWidget") return tr("GlGraphWidget Overview Widget");
  if (feature == "SGHierarchyWidget") return tr("Subgraph Hierarchy Widget");
  return QString::null;
}

QString TulipWidgetsPlugin::whatsThis(const QString& feature) const {
  if (feature == "PropertyWidget") return tr("A widget to display the properties associated to a Tulip graph");
  if (feature == "ElementPropertiesWidget") return tr("A widget to display properties of a node or edge");
  if (feature == "GlGraphWidget") return tr("A widget containing a Tulip GlGraph");
  if (feature == "GWOverviewWidget") return tr("A widget displaying the overview of the GlGraph associated to a GlGraphWidget");
  if (feature == "SGHierarchyWidget") return tr("A widget displaying the subgraphs tree hierarchy of a graph");
  return QString::null;
}

bool TulipWidgetsPlugin::isContainer(const QString& feature) const {
  if (feature == "PropertyWidget") return false;
  if (feature == "ElementPropertiesWidget") return false;
  if (feature == "GlGraphWidget") return false;
  if (feature == "GWOverviewWidget") return false;
  if (feature == "SGHierarchyWidget") return false;
  return false;
}

Q_EXPORT_PLUGIN(TulipWidgetsPlugin);

#endif
