//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef PLUGINLIBLOADER_H
#define PLUGINLIBLOADER_H

#ifndef DOXYGEN_NOTFOR_USER

#include "PluginLoader.h"
#include "tulipconf.h"

namespace tlp {

class TLP_SCOPE PluginLibraryLoader {
 public:
  int n;
  std::string msg;
  std::string pluginPath;
  PluginLoader *loader;

  PluginLibraryLoader(std::string pluginPath, PluginLoader *loader);
  bool hasPluginLibraryToLoad() { return n >= 0; }
  bool loadNextPluginLibrary(PluginLoader *loader);
  static TLP_SCOPE bool loadPluginLibrary(const std::string & filename,
					  PluginLoader *loader = 0);

 private:
  void *infos;
};

}
#endif //DOXYGEN_NOTFOR_USER
#endif //PLUGINLIBLOADER_H
